/*
 * Decompiled with CFR 0.152.
 */
package com.inet.webserver;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ApplicationDescription;
import com.inet.webserver.ListenerConnector;
import com.inet.webserver.acme.b;
import com.inet.webserver.c;
import com.inet.webserver.structure.WebConfigKeys;
import com.inet.webserver.structure.a;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ListenerSettings {
    public static final String CONNECTIONTYPE_PLAIN = "plain";
    public static final String CONNECTIONTYPE_PLAIN_AND_SECURE = "plain_and_secure";
    public static final String CONNECTIONTYPE_SECURE = "secure";
    private ArrayList<ListenerConnector> x = new ArrayList();

    public ListenerSettings() {
        this(false, false, null);
    }

    public ListenerSettings(boolean loadFromConfiguration, boolean autodetectPort, @Nullable String bindAddresses) {
        if (loadFromConfiguration) {
            Configuration configuration = ConfigurationManager.getInstance().getCurrent();
            this.a(configuration, autodetectPort, bindAddresses);
        }
    }

    public ListenerSettings(Configuration config) {
        this.a(config, false, null);
    }

    private void a(Configuration configuration, boolean bl, String string) {
        if (configuration == null) {
            return;
        }
        String string2 = configuration.get(ConfigKey.LISTENER_CONNECTION_TYPE.getKey(), ConfigKey.LISTENER_CONNECTION_TYPE.getDefault());
        int n = ListenerSettings.getPlainPort(configuration);
        int n2 = ListenerSettings.getSslPort(configuration);
        if (string == null) {
            string = configuration.get(ConfigKey.LISTENER_BIND_ADDRESS.getKey());
        }
        if (string != null && string.isEmpty()) {
            string = null;
        }
        if (CONNECTIONTYPE_PLAIN.equals(string2) || CONNECTIONTYPE_PLAIN_AND_SECURE.equals(string2)) {
            try {
                boolean bl2 = ListenerSettings.a(bl, configuration, false);
                this.addPlainConnector(n, bl2, string);
            }
            catch (IOException iOException) {
                c.o.error((Object)"Could not create plain connector.");
                c.o.error((Throwable)iOException);
            }
        }
        if (CONNECTIONTYPE_SECURE.equals(string2) || CONNECTIONTYPE_PLAIN_AND_SECURE.equals(string2)) {
            URL[] uRLArray = ListenerSettings.getCertificateURLs(configuration);
            URL uRL = uRLArray[0];
            URL uRL2 = uRLArray[1];
            try {
                if (uRL != null && uRL2 != null) {
                    boolean bl3 = ListenerSettings.a(bl, configuration, false);
                    this.addSSLConnector(n2, bl3, string, uRL, uRL2);
                }
            }
            catch (IOException iOException) {
                c.o.error((Object)"Could not create ssl connector.");
                c.o.error((Throwable)iOException);
            }
        }
    }

    public static URL @Nonnull [] getCertificateURLs(@Nonnull Configuration config) {
        String string = config.get(WebConfigKeys.CERTIFICATE_TYPE.getKey(), WebConfigKeys.CERTIFICATE_TYPE.getDefault());
        URL uRL = null;
        URL uRL2 = null;
        switch (string) {
            case "fix": {
                String string2 = config.get(ConfigKey.LISTENER_SSL_CERTIFICATE.getKey());
                String string3 = config.get(ConfigKey.LISTENER_SSL_PRIVATEKEY.getKey());
                try {
                    if (string2 != null && string2.length() > 0) {
                        uRL = IOFunctions.getFileURL((String)string2);
                    }
                }
                catch (IOException iOException) {
                    c.o.error((Object)("Could not open ssl certificate at '" + string2 + "'"));
                    c.o.error((Throwable)iOException);
                }
                try {
                    if (string3 == null || string3.length() <= 0) break;
                    uRL2 = IOFunctions.getFileURL((String)string3);
                }
                catch (IOException iOException) {
                    c.o.error((Object)("Could not open ssl private key at '" + string3 + "'"));
                    c.o.error((Throwable)iOException);
                }
                break;
            }
            case "fix.upload": {
                uRL = a.t().w();
                uRL2 = a.u().w();
                break;
            }
            case "letsencrypt": {
                uRL = b.q();
                uRL2 = b.r();
            }
        }
        return new URL[]{uRL, uRL2};
    }

    ArrayList<ListenerConnector> k() {
        return this.x;
    }

    public void addPlainConnector(int port) throws IOException {
        this.addPlainConnector(port, false, null);
    }

    public void addPlainConnector(int port, @Nullable String bindAddresses) throws IOException {
        this.addPlainConnector(port, false, bindAddresses);
    }

    public void addPlainConnector(int port, boolean autodetectPort) throws IOException {
        this.addPlainConnector(port, autodetectPort, null);
    }

    public void addPlainConnector(int port, boolean autodetectPort, @Nullable String bindAddresses) throws IOException {
        String[] stringArray;
        String[] stringArray2;
        if (port == 0) {
            port = ListenerSettings.getPlainPort(ConfigurationManager.getInstance().getCurrent());
        }
        if (bindAddresses == null) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = null;
        } else {
            stringArray2 = bindAddresses.split("[,;]");
        }
        for (String string : stringArray = stringArray2) {
            ListenerConnector listenerConnector = new ListenerConnector(port, autodetectPort, string);
            this.a(listenerConnector);
            this.x.add(listenerConnector);
        }
    }

    public void addSSLConnector(int port, boolean autodetectPort, @Nullable String bindAddresses, URL certificate, URL privateKey) throws IOException {
        String[] stringArray;
        String[] stringArray2;
        if (port == 0) {
            port = ListenerSettings.getSslPort(ConfigurationManager.getInstance().getCurrent());
        }
        if (bindAddresses == null) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = null;
        } else {
            stringArray2 = bindAddresses.split("[,;]");
        }
        for (String string : stringArray = stringArray2) {
            ListenerConnector listenerConnector = new ListenerConnector(port, autodetectPort, string, certificate, privateKey);
            this.a(listenerConnector);
            this.x.add(listenerConnector);
        }
    }

    private void a(ListenerConnector listenerConnector) throws IOException {
        for (ListenerConnector listenerConnector2 : this.x) {
            if (listenerConnector.isAutodetectPort() || listenerConnector.getPort() != listenerConnector2.getPort()) continue;
            boolean bl = listenerConnector.getBindAddress() == null ? listenerConnector2.getBindAddress() == null : listenerConnector.getBindAddress().equals(listenerConnector2.getBindAddress());
            boolean bl2 = bl;
            if (!bl2) continue;
            throw new IOException("A connector with the port '" + listenerConnector.getPort() + "' was already added for bindAddress '" + listenerConnector.getBindAddress() + "'.");
        }
    }

    public static int getPlainPort(Configuration config) {
        return ListenerSettings.getPort(false, config);
    }

    public static int getSslPort(Configuration config) {
        return ListenerSettings.getPort(true, config);
    }

    public static int getPort(boolean ssl, Configuration config) {
        int n;
        String string = ListenerSettings.a(ssl, config);
        try {
            n = Integer.parseInt(Objects.requireNonNullElse(string, "NaN"));
            if (n > 0 && n <= 65535) {
                return n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!ssl) {
            n = ApplicationDescription.get().getDefaultPort();
        } else {
            n = ListenerSettings.getPort(false, config);
            n = n / 1000 * 1000 + 443;
        }
        return n;
    }

    private static boolean a(boolean bl, Configuration configuration, boolean bl2) {
        String string = ListenerSettings.a(bl2, configuration);
        try {
            int n = Integer.parseInt(Objects.requireNonNullElse(string, "NaN"));
            if (n > 0 && n <= 65535) {
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Nullable
    private static String a(boolean bl, Configuration configuration) {
        String string = System.getenv(bl ? "inet_https_port" : "inet_http_port");
        if (StringFunctions.isEmpty((String)string)) {
            string = configuration.get((bl ? ConfigKey.LISTENER_SSL_PORT : ConfigKey.LISTENER_PORT).getKey());
        }
        return string;
    }
}

