/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.provider.zerossl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.provider.AbstractAcmeProvider;

public class ZeroSSLAcmeProvider
extends AbstractAcmeProvider {
    private static final String V02_DIRECTORY_URL = "https://acme.zerossl.com/v2/DV90";

    @Override
    public boolean accepts(URI serverUri) {
        return "acme".equals(serverUri.getScheme()) && "zerossl.com".equals(serverUri.getHost());
    }

    @Override
    public URL resolve(URI serverUri) {
        String path = serverUri.getPath();
        if (path != null && !path.isEmpty() && !"/".equals(path)) {
            throw new IllegalArgumentException("Unknown URI " + String.valueOf(serverUri));
        }
        String directoryUrl = V02_DIRECTORY_URL;
        try {
            return new URL(directoryUrl);
        }
        catch (MalformedURLException ex) {
            throw new AcmeProtocolException(directoryUrl, ex);
        }
    }
}

