/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.provider.sslcom;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.provider.AbstractAcmeProvider;
import org.shredzone.acme4j.toolbox.JSON;

public class SslComAcmeProvider
extends AbstractAcmeProvider {
    private static final String PRODUCTION_ECC_DIRECTORY_URL = "https://acme.ssl.com/sslcom-dv-ecc";
    private static final String PRODUCTION_RSA_DIRECTORY_URL = "https://acme.ssl.com/sslcom-dv-rsa";
    private static final String STAGING_ECC_DIRECTORY_URL = "https://acme-try.ssl.com/sslcom-dv-ecc";
    private static final String STAGING_RSA_DIRECTORY_URL = "https://acme-try.ssl.com/sslcom-dv-rsa";

    @Override
    public boolean accepts(URI serverUri) {
        return "acme".equals(serverUri.getScheme()) && "ssl.com".equals(serverUri.getHost());
    }

    @Override
    public URL resolve(URI serverUri) {
        String directoryUrl;
        String path = serverUri.getPath();
        if (path == null || path.isEmpty() || "/".equals(path) || "/ecc".equals(path)) {
            directoryUrl = PRODUCTION_ECC_DIRECTORY_URL;
        } else if ("/rsa".equals(path)) {
            directoryUrl = PRODUCTION_RSA_DIRECTORY_URL;
        } else if ("/staging".equals(path) || "/staging/ecc".equals(path)) {
            directoryUrl = STAGING_ECC_DIRECTORY_URL;
        } else if ("/staging/rsa".equals(path)) {
            directoryUrl = STAGING_RSA_DIRECTORY_URL;
        } else {
            throw new IllegalArgumentException("Unknown URI " + String.valueOf(serverUri));
        }
        try {
            return new URL(directoryUrl);
        }
        catch (MalformedURLException ex) {
            throw new AcmeProtocolException(directoryUrl, ex);
        }
    }

    @Override
    public JSON directory(Session session, URI serverUri) throws AcmeException {
        JSON superdirectory = super.directory(session, serverUri);
        if (superdirectory == null) {
            return null;
        }
        Map<String, Object> directory = superdirectory.toMap();
        Object meta = directory.get("meta");
        if (meta instanceof Map) {
            Map metaMap = (Map)meta;
            metaMap.remove("externalAccountRequired");
            metaMap.put("externalAccountRequired", true);
        }
        return JSON.fromMap(directory);
    }
}

