/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.connector;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TrimmingInputStream
extends InputStream {
    private final BufferedInputStream in;
    private boolean startOfFile = true;

    public TrimmingInputStream(InputStream in) {
        this.in = new BufferedInputStream(in, 1024);
    }

    @Override
    public int read() throws IOException {
        int ch = this.in.read();
        if (!TrimmingInputStream.isLineSeparator(ch)) {
            this.startOfFile = false;
            return ch;
        }
        this.in.mark(1);
        ch = this.in.read();
        while (TrimmingInputStream.isLineSeparator(ch)) {
            this.in.mark(1);
            ch = this.in.read();
        }
        if (this.startOfFile) {
            this.startOfFile = false;
            return ch;
        }
        this.in.reset();
        return 10;
    }

    @Override
    public int available() throws IOException {
        if (this.in.available() == 0) {
            this.in.mark(1);
            int read = this.in.read();
            this.in.reset();
            if (read < 0) {
                return 0;
            }
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        super.close();
    }

    private static boolean isLineSeparator(int ch) {
        return ch == 10 || ch == 13;
    }
}

