/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.ProvSecretKeySpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class BaseKeyGenerator
extends KeyGeneratorSpi {
    private final BouncyCastleFipsProvider fipsProvider;
    private final String algorithmName;
    private final KeyGeneratorCreator keyGeneratorCreator;
    private final int defaultKeySize;
    private final boolean fixedKeySize;
    private SymmetricKeyGenerator engine;

    BaseKeyGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, int n, KeyGeneratorCreator keyGeneratorCreator) {
        this(bouncyCastleFipsProvider, string, n, false, keyGeneratorCreator);
    }

    BaseKeyGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, int n, boolean bl, KeyGeneratorCreator keyGeneratorCreator) {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.algorithmName = string;
        this.defaultKeySize = n;
        this.keyGeneratorCreator = keyGeneratorCreator;
        this.fixedKeySize = bl;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No AlgorithmParameterSpec are supported");
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        if (secureRandom != null) {
            this.engine = this.keyGeneratorCreator.createInstance(this.defaultKeySize, secureRandom);
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        if (this.fixedKeySize && n != this.defaultKeySize) {
            throw new InvalidParameterException("Attempt to change keysize for fixed size key generator");
        }
        try {
            if (secureRandom == null) {
                secureRandom = this.fipsProvider.getDefaultSecureRandom();
            }
            this.engine = this.keyGeneratorCreator.createInstance(n, secureRandom);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidParameterException(illegalArgumentException.getMessage());
        }
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.engine == null) {
            this.engine = this.keyGeneratorCreator.createInstance(this.defaultKeySize, this.fipsProvider.getDefaultSecureRandom());
        }
        final Object t = this.engine.generateKey();
        return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

            @Override
            public SecretKey run() {
                return new ProvSecretKeySpec(new ValidatedSymmetricKey(t.getAlgorithm(), t.getKeyBytes()), BaseKeyGenerator.this.algorithmName);
            }
        });
    }
}

