/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410Key;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.math.ec.ECPoint;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AsymmetricECGOST3410PublicKey
extends AsymmetricGOST3410Key<ECDomainParameters>
implements AsymmetricPublicKey {
    private ECPoint w;

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, GOST3410Parameters<ECDomainParameters> gOST3410Parameters, ECPoint eCPoint) {
        super(algorithm, gOST3410Parameters);
        this.w = KeyUtils.validated(((ECDomainParameters)this.getParameters().getDomainParameters()).getCurve(), eCPoint);
    }

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(algorithm, ecAcceptable, subjectPublicKeyInfo.getAlgorithm());
        this.w = KeyUtils.validated(((ECDomainParameters)this.getParameters().getDomainParameters()).getCurve(), this.parsePublicKey(subjectPublicKeyInfo));
    }

    private ECPoint parsePublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        byte[] byArray;
        byte[] byArray2;
        ASN1OctetString aSN1OctetString;
        try {
            aSN1OctetString = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error recovering public key: " + iOException.getMessage(), iOException);
        }
        byte[] byArray3 = aSN1OctetString.getOctets();
        if (byArray3.length == 64) {
            int n;
            byArray2 = new byte[32];
            byArray = new byte[32];
            for (n = 0; n != byArray2.length; ++n) {
                byArray2[n] = byArray3[31 - n];
            }
            for (n = 0; n != byArray.length; ++n) {
                byArray[n] = byArray3[63 - n];
            }
        } else {
            int n;
            byArray2 = new byte[64];
            byArray = new byte[64];
            for (n = 0; n != byArray2.length; ++n) {
                byArray2[n] = byArray3[63 - n];
            }
            for (n = 0; n != byArray.length; ++n) {
                byArray[n] = byArray3[127 - n];
            }
        }
        return ((ECDomainParameters)this.getParameters().getDomainParameters()).getCurve().validatePoint(new BigInteger(1, byArray2), new BigInteger(1, byArray));
    }

    public ECPoint getW() {
        return this.w;
    }

    @Override
    public byte[] getEncoded() {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        byte[] byArray;
        BigInteger bigInteger = this.w.getAffineXCoord().toBigInteger();
        BigInteger bigInteger2 = this.w.getAffineYCoord().toBigInteger();
        if (bigInteger.bitLength() > 264 || bigInteger2.bitLength() > 264) {
            byArray = new byte[128];
            this.extractBytes(byArray, 0, bigInteger);
            this.extractBytes(byArray, 64, bigInteger2);
        } else {
            byArray = new byte[64];
            this.extractBytes(byArray, 0, bigInteger);
            this.extractBytes(byArray, 32, bigInteger2);
        }
        if (this.getParameters().getPublicKeyParamSet() != null) {
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(this.getParameters().getPublicKeyParamSet(), this.getParameters().getDigestParamSet(), this.getParameters().getEncryptionParamSet());
            if (byArray.length == 128) {
                return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512, gOST3410PublicKeyAlgParameters), new DEROctetString(byArray));
            }
            if (gOST3410PublicKeyAlgParameters.getEncryptionParamSet().on(RosstandartObjectIdentifiers.id_tc26)) {
                return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256, gOST3410PublicKeyAlgParameters), new DEROctetString(byArray));
            }
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, gOST3410PublicKeyAlgParameters), new DEROctetString(byArray));
        }
        if (byArray.length == 128) {
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512), new DEROctetString(byArray));
        }
        if (this.getParameters().getDomainParameters() instanceof NamedECDomainParameters && (aSN1ObjectIdentifier = ((NamedECDomainParameters)this.getParameters().getDomainParameters()).getID()).on(RosstandartObjectIdentifiers.id_tc26)) {
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256), new DEROctetString(byArray));
        }
        return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001), new DEROctetString(byArray));
    }

    private void extractBytes(byte[] byArray, int n, BigInteger bigInteger) {
        int n2;
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < (n2 = byArray.length / 2)) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        for (int i = 0; i != n2; ++i) {
            byArray[n + i] = byArray2[byArray2.length - 1 - i];
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricECGOST3410PublicKey)) {
            return false;
        }
        AsymmetricECGOST3410PublicKey asymmetricECGOST3410PublicKey = (AsymmetricECGOST3410PublicKey)object;
        return this.w.equals(asymmetricECGOST3410PublicKey.w) && this.getParameters().equals(asymmetricECGOST3410PublicKey.getParameters());
    }

    @Override
    public int hashCode() {
        int n = this.w.hashCode();
        n = 31 * n + this.getParameters().hashCode();
        return n;
    }
}

