/*
 * Decompiled with CFR 0.152.
 */
package com.inet.webserver;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.lib.util.NetworkFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.webserver.c;
import com.inet.webserver.f;
import com.inet.webserver.structure.b;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.ssl.X509;

@InternalApi
public class ListenerConnector {
    private String q;
    private int r;
    private String s;
    private f t;
    private boolean u;
    private SslContextFactory v;
    private String w = "";

    public ListenerConnector(int port, boolean autodetectPort, String bindAddress) {
        this.r = port;
        this.u = autodetectPort;
        this.s = bindAddress;
        this.q = "plain";
    }

    public ListenerConnector(int port, boolean autodetectPort, String bindAddress, URL certificate, URL privateKey) throws IOException {
        this.r = port;
        this.u = autodetectPort;
        this.s = bindAddress;
        this.t = new f(certificate, privateKey);
        this.q = "secure";
        try {
            Collection<? extends Certificate> collection = this.t.getCertificates();
            if (collection == null || collection.size() == 0) {
                throw new IOException("No SSL certificate.");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException("Certificate not valid.", generalSecurityException);
        }
        try {
            if (this.t.l() == null) {
                throw new IOException("No private key.");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException("Private key not valid. Needs to be a PKCS8 encoded key.", generalSecurityException);
        }
    }

    public boolean isAutodetectPort() {
        return this.u;
    }

    public String getBindAddress() {
        return this.s;
    }

    public int getPort() {
        return this.r;
    }

    public String getType() {
        return this.q;
    }

    public f getSslCertificateReader() {
        if (this.t == null) {
            throw new IllegalArgumentException("This connector must be of type 'secure' to provide a ssl certificate reader.");
        }
        return this.t;
    }

    @SuppressFBWarnings(value={"UNENCRYPTED_SERVER_SOCKET", "UNENCRYPTED_SOCKET"}, justification="only free port scan")
    public boolean detectFreePort(int initialPort) {
        if (this.u) {
            for (int i = initialPort; i < 65000; ++i) {
                try {
                    ServerSocket serverSocket = new ServerSocket(i);
                    serverSocket.close();
                    try {
                        new Socket("127.0.0.1", i).close();
                        continue;
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                this.r = i;
                return true;
            }
            return false;
        }
        return false;
    }

    void d(SslContextFactory sslContextFactory) {
        this.v = sslContextFactory;
    }

    String a(boolean bl) {
        if ("".equals(this.w)) {
            if (this.v != null) {
                try {
                    Serializable serializable;
                    Object object;
                    String string = (String)this.v.getAliases().iterator().next();
                    X509 x509 = this.v.getX509(string);
                    f.a(this.getSslCertificateReader().getCertificates());
                    Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                    String string2 = (String)ConfigKey.SERVER_URL.getCurrent();
                    if (!StringFunctions.isEmpty((String)string2) && x509.matches((String)(object = ((URL)(serializable = new URL(string2))).getHost()))) {
                        this.w = ListenerConnector.a(true, (String)object, this.r);
                        return this.w;
                    }
                    serializable = new ArrayList();
                    while (enumeration.hasMoreElements()) {
                        object = enumeration.nextElement();
                        if (!((NetworkInterface)object).isUp()) continue;
                        Enumeration<InetAddress> enumeration2 = ((NetworkInterface)object).getInetAddresses();
                        while (enumeration2.hasMoreElements()) {
                            InetAddress inetAddress2 = enumeration2.nextElement();
                            ((ArrayList)serializable).add(inetAddress2);
                        }
                    }
                    if (serializable.parallelStream().anyMatch(inetAddress -> {
                        try {
                            String string = NetworkFunctions.getCanonicalHostName((InetAddress)inetAddress);
                            if (x509.matches(string)) {
                                this.w = ListenerConnector.a(true, string, this.r);
                                return true;
                            }
                        }
                        catch (Throwable throwable) {
                            c.o.error(throwable);
                        }
                        return false;
                    })) {
                        return this.w;
                    }
                }
                catch (CertificateException certificateException) {
                    ConfigValidationMsg configValidationMsg = b.a(certificateException, Locale.getDefault(), ConfigKey.LISTENER_SSL_CERTIFICATE);
                    if (configValidationMsg.getType() == ConfigValidationMsg.Type.Warning) {
                        c.o.error((Object)configValidationMsg.getMsg());
                    } else {
                        c.o.error((Throwable)certificateException);
                    }
                }
                catch (Exception exception) {
                    c.o.error((Throwable)exception);
                }
                if (!bl) {
                    this.w = null;
                    return null;
                }
            }
        } else if (!bl || this.w != null) {
            return this.w;
        }
        return ListenerConnector.a("secure".equals(this.q), this.s == null ? "localhost" : this.s, this.r);
    }

    @Nonnull
    private static String a(boolean bl, String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(bl ? "https://" : "http://").append(string);
        if (bl && n != 443 || !bl && n != 80) {
            stringBuilder.append(':').append(n);
        }
        return stringBuilder.toString();
    }
}

