/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.client.internal;

import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.DeploymentException;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.ee11.websocket.jakarta.common.ClientEndpointConfigWrapper;
import org.eclipse.jetty.websocket.core.WebSocketComponents;

public class AnnotatedClientEndpointConfig
extends ClientEndpointConfigWrapper {
    public AnnotatedClientEndpointConfig(ClientEndpoint anno, WebSocketComponents components) throws DeploymentException {
        try {
            ClientEndpointConfig.Configurator configurator = (ClientEndpointConfig.Configurator)components.getObjectFactory().createInstance(anno.configurator());
            ClientEndpointConfig build = ClientEndpointConfig.Builder.create().encoders(List.of(anno.encoders())).decoders(List.of(anno.decoders())).preferredSubprotocols(List.of(anno.subprotocols())).extensions(Collections.emptyList()).configurator(configurator).build();
            this.init(build);
        }
        catch (Throwable t) {
            String err = "Unable to instantiate ClientEndpoint.configurator() of " + anno.configurator().getName() + " defined as annotation in " + anno.getClass().getName();
            throw new DeploymentException(err, t);
        }
    }
}

