/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.client;

import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.ee11.websocket.jakarta.client.JakartaWebSocketClientFrameHandlerFactory;
import org.eclipse.jetty.ee11.websocket.jakarta.client.internal.AnnotatedClientEndpointConfig;
import org.eclipse.jetty.ee11.websocket.jakarta.client.internal.BasicClientEndpointConfig;
import org.eclipse.jetty.ee11.websocket.jakarta.client.internal.JakartaClientUpgradeRequest;
import org.eclipse.jetty.ee11.websocket.jakarta.client.internal.JsrUpgradeListener;
import org.eclipse.jetty.ee11.websocket.jakarta.common.ConfiguredEndpoint;
import org.eclipse.jetty.ee11.websocket.jakarta.common.JakartaWebSocketContainer;
import org.eclipse.jetty.ee11.websocket.jakarta.common.JakartaWebSocketExtensionConfig;
import org.eclipse.jetty.ee11.websocket.jakarta.common.JakartaWebSocketFrameHandler;
import org.eclipse.jetty.ee11.websocket.jakarta.common.JakartaWebSocketFrameHandlerFactory;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.client.CoreClientUpgradeRequest;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;
import org.eclipse.jetty.websocket.core.exception.InvalidWebSocketException;
import org.eclipse.jetty.websocket.core.exception.UpgradeException;
import org.eclipse.jetty.websocket.core.exception.WebSocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="JSR356 Client Container")
public class JakartaWebSocketClientContainer
extends JakartaWebSocketContainer
implements WebSocketContainer {
    private static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketClientContainer.class);
    private static final Map<ClassLoader, ContainerLifeCycle> SHUTDOWN_MAP = new ConcurrentHashMap<ClassLoader, ContainerLifeCycle>();
    protected WebSocketCoreClient coreClient;
    protected Function<WebSocketComponents, WebSocketCoreClient> coreClientFactory;
    private final JakartaWebSocketClientFrameHandlerFactory frameHandlerFactory;

    public static void setShutdownContainer(ContainerLifeCycle container) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        SHUTDOWN_MAP.compute(cl, (k, v) -> container);
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialized shutdown map@{} to [{}={}]", new Object[]{SHUTDOWN_MAP.hashCode(), cl, container});
        }
    }

    public JakartaWebSocketClientContainer() {
        this(new WebSocketComponents());
    }

    public JakartaWebSocketClientContainer(HttpClient httpClient) {
        this(new WebSocketComponents(), components -> new WebSocketCoreClient(httpClient, components));
    }

    public JakartaWebSocketClientContainer(WebSocketComponents components) {
        this(components, WebSocketCoreClient::new);
    }

    public JakartaWebSocketClientContainer(WebSocketComponents components, Function<WebSocketComponents, WebSocketCoreClient> coreClientFactory) {
        super(components);
        this.coreClientFactory = coreClientFactory;
        this.frameHandlerFactory = new JakartaWebSocketClientFrameHandlerFactory(this);
    }

    protected HttpClient getHttpClient() {
        return this.getWebSocketCoreClient().getHttpClient();
    }

    protected WebSocketCoreClient getWebSocketCoreClient() {
        if (this.coreClient == null) {
            this.coreClient = this.coreClientFactory.apply(this.components);
            this.addManaged((LifeCycle)this.coreClient);
        }
        return this.coreClient;
    }

    private CompletableFuture<Session> connect(JakartaClientUpgradeRequest upgradeRequest) {
        upgradeRequest.setConfiguration(this.defaultCustomizer);
        CompletableFuture<Session> futureSession = new CompletableFuture<Session>();
        try {
            WebSocketCoreClient coreClient = this.getWebSocketCoreClient();
            coreClient.connect((CoreClientUpgradeRequest)upgradeRequest).whenComplete((coreSession, error) -> {
                if (error != null) {
                    futureSession.completeExceptionally((Throwable)error);
                    return;
                }
                JakartaWebSocketFrameHandler frameHandler = (JakartaWebSocketFrameHandler)upgradeRequest.getFrameHandler();
                futureSession.complete((Session)frameHandler.getSession());
            });
        }
        catch (Exception e) {
            futureSession.completeExceptionally(e);
        }
        return futureSession;
    }

    private Session connect(ConfiguredEndpoint configuredEndpoint, URI destURI) throws IOException, DeploymentException {
        if (configuredEndpoint == null) {
            throw new DeploymentException("WebSocket configured endpoint cannot be null");
        }
        if (destURI == null) {
            throw new DeploymentException("Destination URI cannot be null");
        }
        JakartaClientUpgradeRequest upgradeRequest = new JakartaClientUpgradeRequest(this, this.getWebSocketCoreClient(), destURI, configuredEndpoint);
        EndpointConfig config = configuredEndpoint.getConfig();
        if (config instanceof ClientEndpointConfig) {
            ClientEndpointConfig clientEndpointConfig = (ClientEndpointConfig)config;
            JsrUpgradeListener jsrUpgradeListener = new JsrUpgradeListener(clientEndpointConfig.getConfigurator());
            upgradeRequest.addListener(jsrUpgradeListener);
            for (Extension ext : clientEndpointConfig.getExtensions()) {
                upgradeRequest.addExtensions(new ExtensionConfig[]{new JakartaWebSocketExtensionConfig(ext)});
            }
            if (!clientEndpointConfig.getPreferredSubprotocols().isEmpty()) {
                upgradeRequest.setSubProtocols(clientEndpointConfig.getPreferredSubprotocols());
            }
        }
        long timeout = this.getWebSocketCoreClient().getHttpClient().getConnectTimeout();
        try {
            CompletableFuture<Session> sessionFuture = this.connect(upgradeRequest);
            if (timeout > 0L) {
                return (Session)sessionFuture.get(timeout + 1000L, TimeUnit.MILLISECONDS);
            }
            return (Session)sessionFuture.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof UpgradeException) {
                throw new DeploymentException(cause.getMessage(), cause);
            }
            if (cause instanceof WebSocketTimeoutException) {
                throw new IOException(cause);
            }
            if (cause instanceof InvalidWebSocketException) {
                throw new DeploymentException(e.getMessage(), (Throwable)e);
            }
            throw new IOException(cause);
        }
        catch (TimeoutException e) {
            throw new IOException("Connection future timeout " + timeout + " ms for " + String.valueOf(destURI), e);
        }
        catch (Throwable e) {
            throw new DeploymentException("Unable to connect to " + String.valueOf(destURI), e);
        }
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig providedConfig, URI path) throws DeploymentException, IOException {
        return this.connectToServer(this.newEndpoint(endpointClass), providedConfig, path);
    }

    public Session connectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException, IOException {
        return this.connectToServer(this.newEndpoint(annotatedEndpointClass), path);
    }

    public Session connectToServer(Endpoint endpoint, ClientEndpointConfig providedConfig, URI path) throws DeploymentException, IOException {
        Object config;
        if (providedConfig == null) {
            config = new BasicClientEndpointConfig();
        } else {
            config = providedConfig;
            this.components.getObjectFactory().decorate((Object)providedConfig.getConfigurator());
        }
        ConfiguredEndpoint instance = new ConfiguredEndpoint((Object)endpoint, (EndpointConfig)config);
        return this.connect(instance, path);
    }

    public Session connectToServer(Object endpoint, URI path) throws DeploymentException, IOException {
        ClientEndpointConfig config = this.getAnnotatedConfig(endpoint);
        ConfiguredEndpoint instance = new ConfiguredEndpoint(endpoint, (EndpointConfig)config);
        return this.connect(instance, path);
    }

    public JakartaWebSocketFrameHandlerFactory getFrameHandlerFactory() {
        return this.frameHandlerFactory;
    }

    public Executor getExecutor() {
        return this.getHttpClient().getExecutor();
    }

    private <T> T newEndpoint(Class<T> endpointClass) throws DeploymentException {
        try {
            return endpointClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new DeploymentException("Unable to instantiate websocket: " + endpointClass.getName());
        }
    }

    private ClientEndpointConfig getAnnotatedConfig(Object endpoint) throws DeploymentException {
        ClientEndpoint anno = endpoint.getClass().getAnnotation(ClientEndpoint.class);
        if (anno == null) {
            throw new DeploymentException("Could not get ClientEndpoint annotation for " + endpoint.getClass().getName());
        }
        return new AnnotatedClientEndpointConfig(anno, this.components);
    }

    protected void doStart() throws Exception {
        this.doClientStart();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.doClientStop();
    }

    protected void doClientStart() {
        Object contextHandler;
        if (LOG.isDebugEnabled()) {
            LOG.debug("doClientStart() {}", (Object)this);
        }
        if ((contextHandler = this.getContextHandler()) != null) {
            Container.addBean((Object)contextHandler, (Object)((Object)this), (boolean)true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} registered for ContextHandler shutdown to {}", (Object)this, contextHandler);
            }
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ContainerLifeCycle container = SHUTDOWN_MAP.get(cl);
        if (container != null) {
            container.addManaged((LifeCycle)this);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} registered for WebApp shutdown to {}", (Object)this, (Object)container);
            }
            return;
        }
        ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} registered for JVM shutdown", (Object)this);
        }
    }

    protected void doClientStop() {
        Object contextHandler;
        if (LOG.isDebugEnabled()) {
            LOG.debug("doClientStop() {}", (Object)this);
        }
        if ((contextHandler = this.getContextHandler()) != null) {
            Container.unmanage((Object)contextHandler, (Object)((Object)this));
            Container.removeBean((Object)contextHandler, (Object)((Object)this));
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} deregistered for ContextHandler shutdown from {}", (Object)this, contextHandler);
            }
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ContainerLifeCycle container = SHUTDOWN_MAP.get(cl);
        if (container != null) {
            container.unmanage((Object)this);
            if (container.removeBean((Object)this)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} deregistered for Context shutdown from {}", (Object)this, (Object)container);
                }
                return;
            }
        }
        ShutdownThread.deregister((LifeCycle)this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} deregistered for JVM shutdown", (Object)this);
        }
    }

    public Object getContextHandler() {
        try {
            return ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.eclipse.jetty.server.handler.ContextHandler").getMethod("getCurrentContextHandler", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable x) {
            return null;
        }
    }
}

