/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.exception.AcmeException;

public interface PollableResource {
    public static final Duration DEFAULT_RETRY_AFTER = Duration.ofSeconds(3L);

    public Status getStatus();

    public Optional<Instant> fetch() throws AcmeException;

    default public Status waitForStatus(Set<Status> statusSet, Duration timeout) throws AcmeException, InterruptedException {
        Instant now;
        Objects.requireNonNull(timeout, "timeout");
        Objects.requireNonNull(statusSet, "statusSet");
        if (statusSet.isEmpty()) {
            throw new IllegalArgumentException("At least one Status is required");
        }
        Status currentStatus = this.getStatus();
        if (statusSet.contains((Object)currentStatus)) {
            return currentStatus;
        }
        Instant timebox = Instant.now().plus(timeout);
        while ((now = Instant.now()).isBefore(timebox)) {
            Instant retryAfter = this.fetch().orElse(now.plus(DEFAULT_RETRY_AFTER));
            currentStatus = this.getStatus();
            if (statusSet.contains((Object)currentStatus)) {
                return currentStatus;
            }
            if (retryAfter.isAfter(timebox)) break;
            Thread.sleep(now.until(retryAfter, ChronoUnit.MILLIS));
        }
        throw new AcmeException("Timeout has been reached");
    }
}

