/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.common;

import jakarta.websocket.Encoder;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.eclipse.jetty.ee11.websocket.jakarta.common.JakartaWebSocketRemoteEndpoint;
import org.eclipse.jetty.ee11.websocket.jakarta.common.JakartaWebSocketSession;
import org.eclipse.jetty.ee11.websocket.jakarta.common.SendHandlerCallback;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.messages.MessageOutputStream;
import org.eclipse.jetty.websocket.core.messages.MessageWriter;
import org.eclipse.jetty.websocket.core.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaWebSocketAsyncRemote
extends JakartaWebSocketRemoteEndpoint
implements RemoteEndpoint.Async {
    static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketAsyncRemote.class);

    protected JakartaWebSocketAsyncRemote(JakartaWebSocketSession session, CoreSession coreSession) {
        super(session, coreSession);
        this.messageWriteTimeout = session.getContainer().getDefaultAsyncSendTimeout();
    }

    public long getSendTimeout() {
        return this.messageWriteTimeout;
    }

    public void setSendTimeout(long timeoutMillis) {
        this.messageWriteTimeout = timeoutMillis;
    }

    public Future<Void> sendBinary(ByteBuffer data) {
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({})", (Object)BufferUtil.toDetailString((ByteBuffer)data));
        }
        FutureCallback future = new FutureCallback();
        this.sendFrame(new Frame(2).setPayload(data), (Callback)future, this.batch);
        return future;
    }

    public void sendBinary(ByteBuffer data, SendHandler handler) {
        this.assertMessageNotNull(data);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({},{})", (Object)BufferUtil.toDetailString((ByteBuffer)data), (Object)handler);
        }
        this.sendFrame(new Frame(2).setPayload(data), new SendHandlerCallback(handler), this.batch);
    }

    public Future<Void> sendObject(Object data) {
        FutureCallback future = new FutureCallback();
        try {
            this.sendObject(data, (Callback)future);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable t) {
            future.failed(t);
        }
        return future;
    }

    public void sendObject(Object data, SendHandler handler) {
        Encoder encoder;
        this.assertMessageNotNull(data);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendObject({},{})", data, (Object)handler);
        }
        if ((encoder = this.session.getEncoders().getInstanceFor(data.getClass())) == null) {
            throw new IllegalArgumentException("No encoder for type: " + String.valueOf(data.getClass()));
        }
        if (encoder instanceof Encoder.Text) {
            Encoder.Text textEncoder = (Encoder.Text)encoder;
            try {
                String msg = textEncoder.encode(data);
                this.sendText(msg, handler);
            }
            catch (Throwable t) {
                handler.onResult(new SendResult(t));
            }
            return;
        }
        if (encoder instanceof Encoder.TextStream) {
            Encoder.TextStream textStreamEncoder = (Encoder.TextStream)encoder;
            try {
                MessageWriter writer = this.newMessageWriter();
                writer.setCallback((Callback)new SendHandlerCallback(handler));
                textStreamEncoder.encode(data, (Writer)writer);
                writer.close();
            }
            catch (Throwable t) {
                handler.onResult(new SendResult(t));
            }
            return;
        }
        if (encoder instanceof Encoder.Binary) {
            Encoder.Binary binaryEncoder = (Encoder.Binary)encoder;
            try {
                ByteBuffer buf = binaryEncoder.encode(data);
                this.sendBinary(buf, handler);
            }
            catch (Throwable t) {
                handler.onResult(new SendResult(t));
            }
            return;
        }
        if (encoder instanceof Encoder.BinaryStream) {
            Encoder.BinaryStream binaryStreamEncoder = (Encoder.BinaryStream)encoder;
            SendHandlerCallback callback = new SendHandlerCallback(handler);
            try {
                MessageOutputStream out = this.newMessageOutputStream();
                out.setCallback((Callback)callback);
                binaryStreamEncoder.encode(data, (OutputStream)out);
                out.close();
            }
            catch (Throwable t) {
                handler.onResult(new SendResult(t));
            }
            return;
        }
        throw new IllegalArgumentException("Unknown encoder type: " + String.valueOf(encoder));
    }

    public Future<Void> sendText(String text) {
        this.assertMessageNotNull(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({})", (Object)TextUtils.hint((String)text));
        }
        FutureCallback future = new FutureCallback();
        this.sendFrame(new Frame(1).setPayload(text), (Callback)future, this.batch);
        return future;
    }

    public void sendText(String text, SendHandler handler) {
        this.assertMessageNotNull(text);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({},{})", (Object)TextUtils.hint((String)text), (Object)handler);
        }
        this.sendFrame(new Frame(1).setPayload(text), new SendHandlerCallback(handler), this.batch);
    }
}

