/*
 * Decompiled with CFR 0.152.
 */
package com.inet.webserver;

import com.inet.config.ConfigKey;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.webserver.WebServerPlugin;
import com.inet.webserver.acme.b;
import com.inet.webserver.c;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class f {
    private URL C;
    private URL D;
    private Collection<? extends Certificate> E;
    private RSAPrivateKey F;

    public f(URL uRL, URL uRL2) {
        this.C = uRL;
        this.D = uRL2;
    }

    public synchronized Collection<? extends Certificate> getCertificates() throws IOException, GeneralSecurityException {
        if (this.E != null) {
            return this.E;
        }
        if (this.C == null) {
            throw new IOException("No certificate specified.");
        }
        byte[] byArray = IOFunctions.getFileBuffer((URL)this.C);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try {
            this.E = certificateFactory.generateCertificates((InputStream)new FastByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
            try (PEMParser pEMParser = new PEMParser((Reader)new InputStreamReader((InputStream)new FastByteArrayInputStream(byArray)));){
                Object object;
                JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
                while ((object = pEMParser.readObject()) != null) {
                    if (!(object instanceof X509CertificateHolder)) continue;
                    arrayList.add(jcaX509CertificateConverter.getCertificate((X509CertificateHolder)object));
                }
            }
            if (arrayList.isEmpty()) {
                throw exception;
            }
            this.E = arrayList;
        }
        return this.E;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RSAPrivateKey l() throws IOException, GeneralSecurityException {
        block17: {
            if (this.F != null) {
                return this.F;
            }
            if (this.D == null) {
                throw new IOException("No private key specified.");
            }
            byte[] byArray = IOFunctions.getFileBuffer((URL)this.D);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            try {
                this.F = (RSAPrivateKey)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
            }
            catch (Exception exception) {
                try {
                    this.F = (RSAPrivateKey)keyFactory.generatePrivate(new X509EncodedKeySpec(byArray));
                }
                catch (Exception exception2) {
                    try (PEMParser pEMParser = new PEMParser((Reader)new InputStreamReader((InputStream)new FastByteArrayInputStream(byArray)));){
                        Object object;
                        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
                        do {
                            if ((object = pEMParser.readObject()) == null) {
                                throw exception2;
                            }
                            if (!(object instanceof PEMKeyPair)) continue;
                            this.F = (RSAPrivateKey)jcaPEMKeyConverter.getKeyPair((PEMKeyPair)object).getPrivate();
                            break block17;
                        } while (!(object instanceof PrivateKeyInfo));
                        this.F = (RSAPrivateKey)jcaPEMKeyConverter.getPrivateKey((PrivateKeyInfo)object);
                    }
                    finally {
                        if (this.F == null) {
                            c.o.debug((Object)exception);
                            c.o.debug((Object)exception2);
                        }
                    }
                }
            }
        }
        return this.F;
    }

    private static boolean a(@Nonnull URL uRL) {
        if (uRL.getProtocol().equals("file")) {
            return SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION);
        }
        if (uRL.getProtocol().equals("data") && uRL.toString().startsWith("data:application/ssl-certificate-reader")) {
            return true;
        }
        return b.q().equals(uRL) || b.r().equals(uRL);
    }

    @Nullable
    public static RSAPrivateKey b(@Nullable URL uRL) {
        if (uRL != null) {
            if (!f.a(uRL)) {
                c.o.error((Object)"Private key URL has wrong protocol.");
                return null;
            }
            f f2 = new f(null, uRL);
            try {
                return f2.l();
            }
            catch (IOException | GeneralSecurityException exception) {
                c.o.debug((Object)exception);
            }
        }
        return null;
    }

    @Nullable
    public static Certificate a(@Nullable URL uRL, boolean bl, @Nonnull List<ConfigValidationMsg> list) throws IOException, GeneralSecurityException {
        Object object;
        Object object2;
        Collection<? extends Certificate> collection = null;
        if (uRL != null) {
            if (!f.a(uRL)) {
                c.o.error((Object)"Public key URL has wrong protocol.");
                return null;
            }
            object2 = new f(uRL, null);
            collection = ((f)object2).getCertificates();
        }
        if (collection == null || collection.size() == 0) {
            return null;
        }
        if (bl) {
            try {
                f.a(collection);
            }
            catch (CertificateException certificateException) {
                object = com.inet.webserver.structure.b.a(certificateException, ClientLocale.getThreadLocale(), ConfigKey.LISTENER_SSL_CERTIFICATE);
                list.add((ConfigValidationMsg)object);
            }
        }
        if ((object = (Object)((X509Certificate)(object2 = (X509Certificate)collection.iterator().next())).getKeyUsage()) != null && ((ConfigValidationMsg)object).length > 5 && object[5] != false) {
            list.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, WebServerPlugin.MSG.getMsg("error.validator.certificate.notAWebsiteCertificate", new Object[0]), ConfigKey.LISTENER_SSL_CERTIFICATE));
        }
        long l = System.currentTimeMillis() + 1209600000L;
        for (Certificate certificate : collection) {
            object2 = (X509Certificate)certificate;
            Date date = ((X509Certificate)object2).getNotAfter();
            if (date.getTime() >= l) continue;
            list.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Warning, WebServerPlugin.MSG.getMsg("error.validator.certificate.expired", new Object[]{DateFormat.getDateInstance(2, ClientLocale.getThreadLocale()).format(date)}), ConfigKey.LISTENER_SSL_CERTIFICATE));
        }
        return collection.iterator().next();
    }

    public static void a(Collection<? extends Certificate> collection) throws GeneralSecurityException {
        TrustManager[] trustManagerArray;
        X509Certificate[] x509CertificateArray = new X509Certificate[collection.size()];
        collection.toArray(x509CertificateArray);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        for (TrustManager trustManager : trustManagerArray = trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            x509TrustManager.checkServerTrusted(x509CertificateArray, "RSA");
        }
    }

    public static void a(Certificate certificate, RSAPrivateKey rSAPrivateKey) throws Exception {
        byte[] byArray;
        byte[] byArray2;
        RSAPublicKey rSAPublicKey = (RSAPublicKey)certificate.getPublicKey();
        byte[] byArray3 = rSAPublicKey.getModulus().toByteArray();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-224");
        byte[] byArray4 = messageDigest.digest(byArray3);
        if (!Arrays.equals(byArray4, byArray2 = messageDigest.digest(byArray = rSAPrivateKey.getModulus().toByteArray()))) {
            throw new ClientMessageException(WebServerPlugin.MSG.getMsg("error.validator.privatekey.notMatching", new Object[0]));
        }
    }
}

