/*
 * Decompiled with CFR 0.152.
 */
package com.inet.webserver;

import com.inet.annotations.InternalApi;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

@InternalApi
public class SSLSelfSignedCertificateGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCertificateAndPrivateKey(OutputStream privateKeyTarget, OutputStream certificateTarget, String hostname, String organisation, String location, String countryCode) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        if (hostname == null || hostname.length() == 0) {
            throw new IllegalArgumentException("The hostname must be set.");
        }
        x500NameBuilder.addRDN(BCStyle.CN, hostname);
        if (organisation != null && organisation.length() > 0) {
            x500NameBuilder.addRDN(BCStyle.O, organisation);
        }
        if (location != null && location.length() > 0) {
            x500NameBuilder.addRDN(BCStyle.L, location);
        }
        if (countryCode != null && countryCode.length() > 0) {
            x500NameBuilder.addRDN(BCStyle.C, countryCode.toUpperCase());
        }
        try {
            X509Certificate x509Certificate = SSLSelfSignedCertificateGenerator.generateCertificate(x500NameBuilder.build(), hostname, keyPair, 3650, "SHA256WithRSA");
            privateKeyTarget.write(keyPair.getPrivate().getEncoded());
            privateKeyTarget.flush();
            certificateTarget.write(x509Certificate.getEncoded());
            certificateTarget.flush();
        }
        finally {
            privateKeyTarget.close();
            certificateTarget.close();
        }
    }

    public static X509Certificate generateCertificate(X500Name owner, String hostname, KeyPair pair, int days, String algorithm) throws Exception {
        PrivateKey privateKey = pair.getPrivate();
        Date date = new Date();
        Date date2 = new Date(date.getTime() + (long)days * 86400000L);
        BigInteger bigInteger = new BigInteger(64, new SecureRandom());
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(owner, bigInteger, date, date2, owner, pair.getPublic());
        jcaX509v3CertificateBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(new GeneralName(2, hostname)));
        ContentSigner contentSigner = new JcaContentSignerBuilder(algorithm).build(privateKey);
        X509CertificateHolder x509CertificateHolder = jcaX509v3CertificateBuilder.build(contentSigner);
        return new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
    }
}

