/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.DefaultMultiBlockCipher;
import org.bouncycastle.crypto.internal.StreamCipher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class StreamBlockCipher
extends DefaultMultiBlockCipher
implements StreamCipher {
    private final BlockCipher cipher;

    protected StreamBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public final byte returnByte(byte by) {
        return this.calculateByte(by);
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (n3 + n2 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too small");
        }
        int n4 = n;
        int n5 = n + n2;
        int n6 = n3;
        while (n4 < n5) {
            byArray2[n6++] = this.calculateByte(byArray[n4++]);
        }
        return n2;
    }

    protected abstract byte calculateByte(byte var1);
}

