/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.common;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.ee11.websocket.jakarta.common.JakartaWebSocketSession;
import org.eclipse.jetty.ee11.websocket.jakarta.common.JakartaWebSocketSessionListener;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.Graceful;

public class SessionTracker
extends AbstractLifeCycle
implements JakartaWebSocketSessionListener,
Graceful,
Dumpable {
    private final Set<JakartaWebSocketSession> sessions = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean isShutdown = false;

    public Set<Session> getSessions() {
        return Set.copyOf(this.sessions);
    }

    @Override
    public void onJakartaWebSocketSessionOpened(JakartaWebSocketSession session) {
        this.sessions.add(session);
    }

    @Override
    public void onJakartaWebSocketSessionClosed(JakartaWebSocketSession session) {
        this.sessions.remove(session);
    }

    protected void doStart() throws Exception {
        this.isShutdown = false;
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.sessions.clear();
        super.doStop();
    }

    public CompletableFuture<Void> shutdown() {
        this.isShutdown = true;
        return Graceful.shutdown(() -> {
            for (Session session : this.sessions) {
                if (Thread.interrupted()) break;
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Container being shut down"));
            }
        });
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    @ManagedAttribute(value="Total number of active WebSocket Sessions")
    public int getNumSessions() {
        return this.sessions.size();
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{this.sessions});
    }
}

