/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.connector;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import org.shredzone.acme4j.AcmeResource;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.JSON;

public class ResourceIterator<T extends AcmeResource>
implements Iterator<T> {
    private final Login login;
    private final String field;
    private final Deque<URL> urlList = new ArrayDeque<URL>();
    private final BiFunction<Login, URL, T> creator;
    private boolean eol = false;
    @Nullable
    private URL nextUrl;

    public ResourceIterator(Login login, String field, @Nullable URL start, BiFunction<Login, URL, T> creator) {
        this.login = Objects.requireNonNull(login, "login");
        this.field = Objects.requireNonNull(field, "field");
        this.nextUrl = start;
        this.creator = Objects.requireNonNull(creator, "creator");
    }

    @Override
    public boolean hasNext() {
        if (this.eol) {
            return false;
        }
        if (this.urlList.isEmpty()) {
            this.fetch();
        }
        if (this.urlList.isEmpty()) {
            this.eol = true;
        }
        return !this.urlList.isEmpty();
    }

    @Override
    public T next() {
        URL next;
        if (!this.eol && this.urlList.isEmpty()) {
            this.fetch();
        }
        if ((next = this.urlList.poll()) == null) {
            this.eol = true;
            throw new NoSuchElementException("no more " + this.field);
        }
        return (T)((AcmeResource)this.creator.apply(this.login, next));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannot remove " + this.field);
    }

    private void fetch() {
        if (this.nextUrl == null) {
            return;
        }
        try {
            this.readAndQueue();
        }
        catch (AcmeException ex) {
            throw new AcmeProtocolException("failed to read next set of " + this.field, ex);
        }
    }

    private void readAndQueue() throws AcmeException {
        Session session = this.login.getSession();
        try (Connection conn = session.connect();){
            conn.sendSignedPostAsGetRequest(Objects.requireNonNull(this.nextUrl), this.login);
            this.fillUrlList(conn.readJsonResponse());
            this.nextUrl = conn.getLinks("next").stream().findFirst().orElse(null);
        }
    }

    private void fillUrlList(JSON json) {
        json.get(this.field).asArray().stream().map(JSON.Value::asURL).forEach(this.urlList::add);
    }
}

