/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.server;

import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.server.ServerEndpoint;
import org.eclipse.jetty.ee11.websocket.jakarta.client.JakartaWebSocketClientFrameHandlerFactory;
import org.eclipse.jetty.ee11.websocket.jakarta.common.JakartaWebSocketContainer;
import org.eclipse.jetty.ee11.websocket.jakarta.common.JakartaWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.ee11.websocket.jakarta.server.internal.JakartaServerUpgradeRequest;
import org.eclipse.jetty.ee11.websocket.jakarta.server.internal.PathParamIdentifier;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.exception.InvalidWebSocketException;
import org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import org.eclipse.jetty.websocket.core.util.InvokerUtils;

public class JakartaWebSocketServerFrameHandlerFactory
extends JakartaWebSocketClientFrameHandlerFactory
implements FrameHandlerFactory {
    public JakartaWebSocketServerFrameHandlerFactory(JakartaWebSocketContainer container) {
        super(container, (InvokerUtils.ParamIdentifier)new PathParamIdentifier());
    }

    public JakartaWebSocketFrameHandlerMetadata getMetadata(Class<?> endpointClass, EndpointConfig endpointConfig) throws DeploymentException {
        if (Endpoint.class.isAssignableFrom(endpointClass)) {
            return this.createEndpointMetadata(endpointConfig);
        }
        ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
        if (anno == null) {
            return super.getMetadata(endpointClass, endpointConfig);
        }
        UriTemplatePathSpec templatePathSpec = new UriTemplatePathSpec(anno.value());
        JakartaWebSocketFrameHandlerMetadata metadata = new JakartaWebSocketFrameHandlerMetadata(endpointConfig, this.components);
        metadata.setUriTemplatePathSpec(templatePathSpec);
        return this.discoverJakartaFrameHandlerMetadata(endpointClass, metadata);
    }

    public FrameHandler newFrameHandler(Object websocketPojo, ServerUpgradeRequest upgradeRequest, ServerUpgradeResponse upgradeResponse) {
        try {
            return this.newJakartaWebSocketFrameHandler(websocketPojo, new JakartaServerUpgradeRequest(upgradeRequest));
        }
        catch (DeploymentException e) {
            throw new InvalidWebSocketException(e.getMessage(), (Throwable)e);
        }
    }
}

