/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.generator;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.FrameType;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.generator.FrameGenerator;
import org.eclipse.jetty.http3.qpack.QpackEncoder;
import org.eclipse.jetty.http3.qpack.QpackException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.util.VarLenInt;
import org.eclipse.jetty.util.BufferUtil;

public class HeadersGenerator
extends FrameGenerator {
    private final QpackEncoder encoder;
    private final boolean useDirectByteBuffers;

    public HeadersGenerator(ByteBufferPool bufferPool, QpackEncoder encoder, boolean useDirectByteBuffers) {
        super(bufferPool);
        this.encoder = encoder;
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    @Override
    public long generate(ByteBufferPool.Accumulator accumulator, long streamId, Frame frame, Consumer<Throwable> fail) {
        HeadersFrame headersFrame = (HeadersFrame)frame;
        return this.generateHeadersFrame(accumulator, streamId, headersFrame, fail);
    }

    private long generateHeadersFrame(ByteBufferPool.Accumulator accumulator, long streamId, HeadersFrame frame, Consumer<Throwable> fail) {
        int frameTypeLength = VarLenInt.length((long)FrameType.HEADERS.type());
        int maxHeaderLength = frameTypeLength + 8;
        int maxLength = this.encoder.getMaxHeadersSize();
        RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(maxHeaderLength + maxLength, this.useDirectByteBuffers);
        accumulator.append((RetainableByteBuffer)buffer);
        try {
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            BufferUtil.clearToFill((ByteBuffer)byteBuffer);
            byteBuffer.position(maxHeaderLength);
            byteBuffer.limit(byteBuffer.position() + maxLength);
            this.encoder.encode(byteBuffer, streamId, frame.getMetaData());
            byteBuffer.flip();
            byteBuffer.position(maxHeaderLength);
            long dataLength = buffer.remaining();
            int headerLength = frameTypeLength + VarLenInt.length((long)dataLength);
            int position = byteBuffer.position() - headerLength;
            byteBuffer.position(position);
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)FrameType.HEADERS.type());
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)dataLength);
            byteBuffer.position(position);
            return (long)headerLength + dataLength;
        }
        catch (QpackException x) {
            if (fail != null) {
                fail.accept(x);
            }
            return -1L;
        }
    }
}

