/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.util.HashMap;
import java.util.Map;

public enum StreamType {
    CONTROL_STREAM(0L),
    PUSH_STREAM(1L),
    ENCODER_STREAM(2L),
    DECODER_STREAM(3L);

    private final long type;

    public static StreamType from(long type) {
        return Types.types.get(type);
    }

    public static boolean isReserved(long streamType) {
        return (streamType - 33L) % 31L == 0L;
    }

    private StreamType(long type) {
        this.type = type;
        Types.types.put(type, this);
    }

    public long type() {
        return this.type;
    }

    private static class Types {
        private static final Map<Long, StreamType> types = new HashMap<Long, StreamType>();

        private Types() {
        }
    }
}

