/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.api.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.api.frames.Frame;

public class StreamFrame
extends Frame.WithStreamId {
    public static final long END_STREAM_MASK = 1L;
    public static final long LENGTH_MASK = 2L;
    public static final long OFFSET_MASK = 4L;
    private final long offset;
    private final ByteBuffer data;
    private final int length;
    private final boolean endStream;
    private final boolean endData;

    private static long toFrameType(boolean hasOffset, boolean hasLength, boolean endStream) {
        long result = 8L;
        if (hasOffset) {
            result |= 4L;
        }
        if (hasLength) {
            result |= 2L;
        }
        if (endStream) {
            result |= 1L;
        }
        return result;
    }

    public StreamFrame(long streamId, ByteBuffer data, boolean endStream) {
        this(streamId, data, 0L, endStream);
    }

    public StreamFrame(long streamId, ByteBuffer data, long offset, boolean endStream) {
        this(streamId, data, offset, true, endStream);
    }

    public StreamFrame(long streamId, ByteBuffer data, long offset, boolean hasLength, boolean endStream) {
        this(StreamFrame.toFrameType(offset >= 0L, hasLength, endStream), streamId, data, offset, true);
    }

    public StreamFrame(long frameType, long streamId, ByteBuffer data, long offset, boolean endData) {
        super(frameType, streamId);
        this.offset = offset < 0L ? 0L : offset;
        this.data = data;
        this.length = data.remaining();
        this.endStream = (frameType & 1L) == 1L;
        this.endData = endData;
    }

    public long getOffset() {
        return this.offset;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    public boolean isEndData() {
        return this.endData;
    }

    @Override
    public String toString() {
        return "%s[offset=%d,length=%d/%d,last=%b]".formatted(super.toString(), this.getOffset(), this.getData().remaining(), this.getLength(), this.isEndStream());
    }
}

