/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.server.internal;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jetty.quic.quiche.Quiche;

public class SimpleTokenValidator
implements Quiche.TokenValidator {
    private final InetSocketAddress inetSocketAddress;
    private final byte[] implName = "jetty".getBytes(StandardCharsets.US_ASCII);

    public SimpleTokenValidator(InetSocketAddress inetSocketAddress) {
        this.inetSocketAddress = inetSocketAddress;
    }

    public byte[] validate(byte[] token, int len) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(token).limit(len);
        if (byteBuffer.remaining() < this.implName.length) {
            return null;
        }
        byte[] subTokenMarker = new byte[this.implName.length];
        byteBuffer.get(subTokenMarker);
        if (!Arrays.equals(subTokenMarker, this.implName)) {
            return null;
        }
        byte[] address = this.inetSocketAddress.getAddress().getAddress();
        if (byteBuffer.remaining() < address.length) {
            return null;
        }
        byte[] subTokenAddress = new byte[address.length];
        byteBuffer.get(subTokenAddress);
        if (!Arrays.equals(subTokenAddress, address)) {
            return null;
        }
        byte[] port = ByteBuffer.allocate(2).putShort((short)this.inetSocketAddress.getPort()).array();
        if (byteBuffer.remaining() < port.length) {
            return null;
        }
        byte[] subTokenPort = new byte[port.length];
        byteBuffer.get(subTokenPort);
        if (!Arrays.equals(port, subTokenPort)) {
            return null;
        }
        byte[] odcid = new byte[byteBuffer.remaining()];
        byteBuffer.get(odcid);
        return odcid;
    }
}

