/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.server;

import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.quiche.server.QuicheServerQuicConfiguration;
import org.eclipse.jetty.quic.quiche.server.internal.ServerQuicheConnection;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuicheServerConnectionFactory
extends AbstractConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractQuicheServerConnectionFactory.class);
    private final SslContextFactory.Server sslContextFactory;
    private final QuicheServerQuicConfiguration quicConfiguration;
    private final Session.Listener.Factory sessionListenerFactory;

    public AbstractQuicheServerConnectionFactory(SslContextFactory.Server sslContextFactory, QuicheServerQuicConfiguration quicConfiguration, Session.Listener.Factory sessionListenerFactory) {
        super("quic");
        this.sslContextFactory = sslContextFactory;
        this.quicConfiguration = quicConfiguration;
        this.sessionListenerFactory = sessionListenerFactory;
    }

    public SslContextFactory.Server getSslContextFactory() {
        return this.sslContextFactory;
    }

    public QuicheServerQuicConfiguration getServerQuicConfiguration() {
        return this.quicConfiguration;
    }

    public Session.Listener.Factory getSessionListenerFactory() {
        return this.sessionListenerFactory;
    }

    public int getInputBufferSize() {
        return this.quicConfiguration.getInputBufferSize();
    }

    public void setInputBufferSize(int size) {
        this.quicConfiguration.setInputBufferSize(size);
    }

    protected void doStart() throws Exception {
        LOG.info("HTTP/3+QUIC support is experimental and not suited for production use.");
        this.addBean(this.sslContextFactory);
        this.addBean((Object)this.quicConfiguration);
        super.doStart();
        this.quicConfiguration.configure(this.sslContextFactory);
    }

    protected void doStop() throws Exception {
        this.quicConfiguration.deconfigure(this.sslContextFactory);
        super.doStop();
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        ServerQuicheConnection connection = new ServerQuicheConnection(connector, this.getSslContextFactory(), this.getServerQuicConfiguration(), endPoint, this.getSessionListenerFactory());
        return this.configure((AbstractConnection)connection, connector, endPoint);
    }
}

