/*
 * Decompiled with CFR 0.152.
 */
package com.inet.webserver.http3;

import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.ServerPluginManager;
import com.inet.webserver.Http3ConnectorFactory;
import com.inet.webserver.ListenerConnector;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jetty.http3.server.HTTP3ServerConnectionFactory;
import org.eclipse.jetty.http3.server.HTTP3ServerQuicConfiguration;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.server.QuicheServerConnector;
import org.eclipse.jetty.quic.quiche.server.QuicheServerQuicConfiguration;
import org.eclipse.jetty.quic.server.ServerQuicConfiguration;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class a
implements Http3ConnectorFactory {
    private static final Logger a = LogManager.getLogger((String)"Webserver");

    @Nullable
    public AbstractConnector addHttp3Connector(@Nonnull Server server, @Nonnull ListenerConnector listenerConnector, @Nonnull HttpConfiguration httpConfig, @Nonnull SslContextFactory.Server sslContextFactory) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Class.forName(QuicheConnection.class.getName(), true, classLoader);
            Class.forName(Quiche.class.getName(), true, classLoader);
        }
        catch (Throwable throwable) {
            ServerPluginManager.getInstance().setPluginLoadError("webserver.http3", throwable);
            a.error(throwable);
            return null;
        }
        Path path = Path.of(System.getProperty("user.home"), ".ssh", "inet");
        Files.createDirectories(path, new FileAttribute[0]);
        QuicheServerQuicConfiguration quicheServerQuicConfiguration = (QuicheServerQuicConfiguration)HTTP3ServerQuicConfiguration.configure((ServerQuicConfiguration)new QuicheServerQuicConfiguration(path));
        HTTP3ServerConnectionFactory hTTP3ServerConnectionFactory = new HTTP3ServerConnectionFactory(httpConfig);
        QuicheServerConnector quicheServerConnector = new QuicheServerConnector(server, sslContextFactory, quicheServerQuicConfiguration, new ConnectionFactory[]{hTTP3ServerConnectionFactory});
        quicheServerConnector.setPort(listenerConnector.getPort());
        String string = listenerConnector.getBindAddress();
        if (string != null && string.length() > 0) {
            quicheServerConnector.setHost(string);
        }
        server.addConnector((Connector)quicheServerConnector);
        return quicheServerConnector;
    }
}

