/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.api;

import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Promise;

public interface Stream {
    public long getId();

    public Session getSession();

    public void data(DataFrame var1, Promise.Invocable<Stream> var2);

    public Content.Chunk read();

    public void demand();

    public void trailer(HeadersFrame var1, Promise.Invocable<Stream> var2);

    public void disconnect(long var1, Throwable var3, Promise.Invocable<Stream> var4);

    public static interface Server
    extends Stream {
        public void respond(HeadersFrame var1, Promise.Invocable<Stream> var2);

        public static interface Listener {
            default public void onRequest(Server stream, HeadersFrame frame) {
                if (!frame.isLast()) {
                    stream.demand();
                }
            }

            default public void onDataAvailable(Server stream) {
                try {
                    Content.Chunk chunk;
                    do {
                        if ((chunk = stream.read()) == null) {
                            stream.demand();
                            return;
                        }
                        chunk.release();
                    } while (!chunk.isLast());
                    return;
                }
                catch (Throwable x) {
                    this.onFailure(stream, HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), x);
                    return;
                }
            }

            default public void onDataAvailable(Server stream, boolean immediate) {
                this.onDataAvailable(stream);
            }

            default public void onTrailer(Server stream, HeadersFrame frame) {
            }

            default public void onIdleTimeout(Server stream, TimeoutException failure, Promise<Boolean> promise) {
                promise.succeeded((Object)true);
            }

            default public void onFailure(Server stream, long error, Throwable failure) {
            }
        }
    }

    public static interface Client
    extends Stream {

        public static interface Listener {
            default public void onNewStream(Client stream) {
            }

            default public void onResponse(Client stream, HeadersFrame frame) {
                if (!frame.isLast()) {
                    stream.demand();
                }
            }

            default public void onDataAvailable(Client stream) {
                try {
                    Content.Chunk chunk;
                    do {
                        if ((chunk = stream.read()) == null) {
                            stream.demand();
                            return;
                        }
                        chunk.release();
                    } while (!chunk.isLast());
                    return;
                }
                catch (Throwable x) {
                    this.onFailure(stream, HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), x);
                    return;
                }
            }

            default public void onDataAvailable(Client stream, boolean immediate) {
                this.onDataAvailable(stream);
            }

            default public void onTrailer(Client stream, HeadersFrame frame) {
            }

            default public void onIdleTimeout(Client stream, Throwable failure, Promise<Boolean> promise) {
                promise.succeeded((Object)true);
            }

            default public void onFailure(Client stream, long error, Throwable failure) {
            }
        }
    }
}

