/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.generator.MessageGenerator;
import org.eclipse.jetty.http3.qpack.QpackEncoder;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFlusher
extends IteratingCallback {
    private static final Logger LOG = LoggerFactory.getLogger(MessageFlusher.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<Entry> entries = new ArrayDeque<Entry>();
    private final ByteBufferPool.Accumulator accumulator = new ByteBufferPool.Accumulator();
    private final MessageGenerator generator;
    private Entry entry;

    public MessageFlusher(ByteBufferPool bufferPool, QpackEncoder encoder, boolean useDirectByteBuffers) {
        this.generator = new MessageGenerator(bufferPool, encoder, useDirectByteBuffers);
    }

    public boolean offer(StreamEndPoint endPoint, Frame frame, Callback callback) {
        try (AutoLock ignored = this.lock.lock();){
            this.entries.offer(new Entry(endPoint, frame, callback));
        }
        return true;
    }

    protected IteratingCallback.Action process() {
        try (AutoLock ignored = this.lock.lock();){
            this.entry = this.entries.poll();
            if (this.entry == null) {
                IteratingCallback.Action action = IteratingCallback.Action.IDLE;
                return action;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {} on {}", (Object)this.entry, (Object)this);
        }
        Frame frame = this.entry.frame;
        long generated = this.generator.generate(this.accumulator, this.entry.endPoint.getStream().getId(), frame, this::onGenerateFailure);
        if (generated < 0L) {
            return IteratingCallback.Action.SCHEDULED;
        }
        StreamEndPoint endPoint = this.entry.endPoint;
        List buffers = this.accumulator.getByteBuffers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing {} buffers ({} bytes) for stream #{} on {}", new Object[]{buffers.size(), this.accumulator.getTotalLength(), endPoint.getStream().getId(), this});
        }
        endPoint.write(Frame.isLast(frame), buffers, Callback.from((Invocable.InvocationType)this.entry.callback.getInvocationType(), this::onWriteSuccess, this::onWriteFailure));
        return IteratingCallback.Action.SCHEDULED;
    }

    private void onGenerateFailure(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed to generate {} on {}", new Object[]{this.entry, this, cause});
        }
        this.accumulator.release();
        this.entry.callback.failed(cause);
        this.entry = null;
        this.succeeded();
    }

    private void onWriteSuccess() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("succeeded to write {} on {}", (Object)this.entry, (Object)this);
        }
        this.accumulator.release();
        this.entry.callback.succeeded();
        this.entry = null;
        this.succeeded();
    }

    private void onWriteFailure(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed to write {} on {}", new Object[]{this.entry, this, failure});
        }
        this.accumulator.release();
        this.entry.callback.failed(failure);
        this.entry = null;
        this.succeeded();
    }

    public Invocable.InvocationType getInvocationType() {
        if (this.entry == null) {
            return Invocable.InvocationType.NON_BLOCKING;
        }
        return this.entry.callback.getInvocationType();
    }

    private record Entry(StreamEndPoint endPoint, Frame frame, Callback callback) {
        @Override
        public String toString() {
            return String.format("%s#%d", this.frame, this.endPoint.getStream().getId());
        }
    }
}

