/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common.internal.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.api.frames.StreamFrame;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.quic.util.QuicException;
import org.eclipse.jetty.quic.util.VarLenInt;

public class StreamParser {
    private final VarLenInt varLenInt;
    private State state = State.FRAME_TYPE;
    private int maxFrameSize;
    private int frameSize;
    private long frameType;
    private boolean hasOffset;
    private boolean hasLength;
    private long streamId;
    private long offset = -1L;
    private long dataLength = -1L;

    public StreamParser(VarLenInt varLenInt) {
        this.varLenInt = varLenInt;
    }

    public int getFrameMaxSize() {
        return this.maxFrameSize;
    }

    public void setFrameMaxSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public StreamFrame parse(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    if (!this.varLenInt.tryDecode(byteBuffer, (l, v) -> {
                        this.frameSize += l;
                        this.frameType = v;
                    })) break;
                    this.hasOffset = (this.frameType & 4L) == 4L;
                    this.hasLength = (this.frameType & 2L) == 2L;
                    this.state = State.STREAM_ID;
                    break;
                }
                case 1: {
                    if (!this.varLenInt.tryDecode(byteBuffer, (l, v) -> {
                        this.frameSize += l;
                        this.streamId = v;
                    })) break;
                    if (this.hasOffset) {
                        this.state = State.OFFSET;
                        break;
                    }
                    if (this.hasLength) {
                        this.state = State.LENGTH;
                        break;
                    }
                    this.state = State.DATA;
                    break;
                }
                case 2: {
                    if (!this.varLenInt.tryDecode(byteBuffer, (l, v) -> {
                        this.frameSize += l;
                        this.offset = v;
                    })) break;
                    if (this.hasLength) {
                        this.state = State.LENGTH;
                        break;
                    }
                    this.state = State.DATA;
                    break;
                }
                case 3: {
                    if (!this.varLenInt.tryDecode(byteBuffer, (l, v) -> {
                        this.frameSize += l;
                        this.dataLength = v;
                    })) break;
                    if (this.dataLength == 0L) {
                        return this.result(byteBuffer.slice(byteBuffer.position(), 0), true);
                    }
                    this.state = State.DATA;
                    break;
                }
                case 4: {
                    if (this.dataLength < 0L) {
                        this.dataLength = this.getFrameMaxSize() - this.frameSize;
                    }
                    if (this.dataLength + (long)this.frameSize > (long)this.getFrameMaxSize()) {
                        throw new QuicException(ErrorCode.FRAME_ENCODING_ERROR, "invalid_frame_size", this.frameType);
                    }
                    int length = (int)Math.min(this.dataLength, (long)byteBuffer.remaining());
                    ByteBuffer data = byteBuffer.slice(byteBuffer.position(), length);
                    byteBuffer.position(byteBuffer.position() + length);
                    this.dataLength -= (long)length;
                    boolean done = this.dataLength == 0L;
                    return this.result(data, done);
                }
            }
        }
        return null;
    }

    private StreamFrame result(ByteBuffer data, boolean complete) {
        long type = this.frameType;
        long off = this.offset;
        if (!complete) {
            boolean endStream;
            if (off < 0L) {
                off = 0L;
            }
            boolean bl = endStream = ((type |= 4L) & 1L) == 1L;
            if (endStream) {
                type &= 0xFFFFFFFFFFFFFFFEL;
            }
            this.offset += (long)data.remaining();
        }
        StreamFrame frame = new StreamFrame(type, this.streamId, data, off, complete);
        if (complete) {
            this.reset();
        }
        return frame;
    }

    private void reset() {
        this.state = State.FRAME_TYPE;
        this.frameType = 0L;
        this.frameSize = 0;
        this.hasOffset = false;
        this.hasLength = false;
        this.streamId = 0L;
        this.offset = -1L;
        this.dataLength = -1L;
    }

    private static enum State {
        FRAME_TYPE,
        STREAM_ID,
        OFFSET,
        LENGTH,
        DATA;

    }
}

