/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common.internal.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.api.frames.DataBlockedFrame;
import org.eclipse.jetty.quic.util.VarLenInt;

public class DataBlockedParser {
    private final VarLenInt varLenInt;
    private State state = State.FRAME_TYPE;
    private long maxData;

    public DataBlockedParser(VarLenInt varLenInt) {
        this.varLenInt = varLenInt;
    }

    public DataBlockedFrame parse(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    byteBuffer.get();
                    this.state = State.MAX_DATA;
                    break;
                }
                case 1: {
                    if (!this.varLenInt.tryDecode(byteBuffer, v -> {
                        this.maxData = v;
                    })) break;
                    return this.result();
                }
            }
        }
        return null;
    }

    private DataBlockedFrame result() {
        DataBlockedFrame frame = new DataBlockedFrame(this.maxData);
        this.state = State.FRAME_TYPE;
        this.maxData = 0L;
        return frame;
    }

    private static enum State {
        FRAME_TYPE,
        MAX_DATA;

    }
}

