/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.common.AbstractSession;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamEndPoint
implements EndPoint {
    private static final Logger LOG = LoggerFactory.getLogger(StreamEndPoint.class);
    private final AutoLock lock = new AutoLock();
    private final long created = System.currentTimeMillis();
    private final AtomicReference<WriteState> writeState = new AtomicReference<WriteState>(WriteState.IDLE);
    private final AtomicReference<Throwable> writeFailure = new AtomicReference();
    private final ProtocolSession protocolSession;
    private final Stream stream;
    private Connection connection;
    private Content.Chunk chunk;
    private Callback fillInterest;

    public StreamEndPoint(ProtocolSession protocolSession, Stream stream) {
        this.protocolSession = protocolSession;
        this.stream = stream;
    }

    public ProtocolSession getProtocolSession() {
        return this.protocolSession;
    }

    public Stream getStream() {
        return this.stream;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.stream.getSession().getLocalSocketAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.stream.getSession().getRemoteSocketAddress();
    }

    public boolean isOpen() {
        return !this.stream.isClosed();
    }

    public long getCreatedTimeStamp() {
        return this.created;
    }

    public Object getTransport() {
        return this.stream;
    }

    public long getIdleTimeout() {
        return this.stream.getIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeout) {
        this.stream.setIdleTimeout(idleTimeout);
    }

    public void shutdownOutput() {
        block5: while (true) {
            WriteState current = this.writeState.get();
            switch (current.ordinal()) {
                case 0: 
                case 2: {
                    if (!this.writeState.compareAndSet(current, WriteState.CLOSED)) continue block5;
                    this.shutdownOutput(ErrorCode.NO_ERROR.code(), (Promise.Invocable<StreamEndPoint>)Promise.Invocable.noop());
                    return;
                }
                case 1: {
                    if (!this.writeState.compareAndSet(current, WriteState.CLOSING)) continue block5;
                    return;
                }
                case 3: 
                case 4: {
                    return;
                }
            }
        }
    }

    public boolean isOutputShutdown() {
        WriteState state = this.writeState.get();
        return state != WriteState.IDLE && state != WriteState.PENDING;
    }

    public boolean isInputShutdown() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.chunk != null && this.chunk.isLast() && !this.chunk.hasRemaining();
            return bl;
        }
    }

    public void shutdownInput(long appError) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("shutting down input with error 0x{} on {}", (Object)Long.toHexString(appError), (Object)this);
        }
        this.stream.stopSending(appError, Promise.Invocable.noop());
    }

    public void shutdownOutput(long appError, Promise.Invocable<StreamEndPoint> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("shutting down output with error 0x{} on {}", (Object)Long.toHexString(appError), (Object)this);
        }
        this.stream.reset(appError, Promise.Invocable.toPromise(promise, stream -> this));
    }

    public void close(Throwable failure) {
        try (Blocker.Promise promise = Blocker.promise();){
            this.disconnect(ErrorCode.NO_ERROR.code(), failure, true, (Promise.Invocable<StreamEndPoint>)Promise.Invocable.from(() -> this.onClose(failure), (Promise.Invocable)promise));
            promise.block();
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
    }

    public void disconnect(long appError, Throwable failure, boolean disconnectStream, Promise.Invocable<StreamEndPoint> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("disconnecting with error 0x{} disconnectStream={} {} {}", new Object[]{Long.toHexString(appError), disconnectStream, this, String.valueOf(failure)});
        }
        this.getProtocolSession().removeStreamEndPoint(this);
        if (!disconnectStream) {
            promise.succeeded((Object)this);
            return;
        }
        this.stream.disconnect(appError, failure, Promise.Invocable.toPromise(promise, s -> this));
    }

    public void onClose(Throwable failure) {
        this.getConnection().onClose(failure);
    }

    void onIdleTimeout(TimeoutException timeout, Promise.Invocable<Boolean> promise) {
        promise.succeeded((Object)true);
    }

    void onFailure(Throwable failure) {
        Callback callback;
        try (AutoLock ignored = this.lock.lock();){
            if (this.chunk == null) {
                this.chunk = Content.Chunk.from((Throwable)failure);
            } else if (!this.chunk.isLast() || this.chunk.hasRemaining()) {
                this.chunk.release();
                this.chunk = Content.Chunk.from((Throwable)failure);
            }
            callback = this.fillInterest;
            this.fillInterest = null;
        }
        if (callback != null) {
            callback.failed(failure);
        } else {
            this.protocolSession.onStreamFailure(this.stream.getId(), failure);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int fill(ByteBuffer sink) throws IOException {
        ignored = this.lock.lock();
        try {
            current = this.chunk;
            if (current == null || !current.isLast() || current.hasRemaining()) {
                this.chunk = null;
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        do {
            if (current != null) {
                source = current.getByteBuffer();
                if (source.hasRemaining()) {
                    filled = this.copy(current, sink);
                    release = true;
                    if (source.hasRemaining()) {
                        ignored = this.lock.lock();
                        try {
                            if (this.chunk != null) ** GOTO lbl38
                            this.chunk = current;
                            release = false;
                        }
                        finally {
                            if (ignored != null) {
                                ignored.close();
                            }
                        }
                    } else {
                        ignored = this.lock.lock();
                        try {
                            if (this.chunk == null && current.isLast()) {
                                this.chunk = Content.Chunk.EOF;
                            }
                        }
                        finally {
                            if (ignored != null) {
                                ignored.close();
                            }
                        }
                    }
                    if (release) {
                        current.release();
                    }
                    if (StreamEndPoint.LOG.isDebugEnabled()) {
                        StreamEndPoint.LOG.debug("filled {} bytes on {}", (Object)filled, (Object)this);
                    }
                    return filled;
                }
                if (Content.Chunk.isFailure((Content.Chunk)current)) {
                    ignored = this.lock.lock();
                    try {
                        if (this.chunk == null) {
                            this.chunk = current;
                        }
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                    throw IO.rethrow((Throwable)current.getFailure());
                }
                if (current.isLast()) {
                    if (current != Content.Chunk.EOF) {
                        ignored = this.lock.lock();
                        try {
                            if (this.chunk == null) {
                                this.chunk = Content.Chunk.EOF;
                            }
                        }
                        finally {
                            if (ignored != null) {
                                ignored.close();
                            }
                        }
                        current.release();
                    }
                    return -1;
                }
            }
            current = this.stream.read();
            if (!StreamEndPoint.LOG.isDebugEnabled()) continue;
            StreamEndPoint.LOG.debug("read {} from {} on {}", new Object[]{current, this.stream, this});
        } while (current != null);
        return 0;
    }

    public Content.Chunk fill() {
        Content.Chunk current;
        try (AutoLock ignored = this.lock.lock();){
            current = this.chunk;
        }
        if (current == null) {
            current = this.stream.read();
        }
        return current;
    }

    private int copy(Content.Chunk chunk, ByteBuffer sink) {
        int length = 0;
        ByteBuffer source = chunk.getByteBuffer();
        if (source.hasRemaining()) {
            int sinkPosition = BufferUtil.flipToFill((ByteBuffer)sink);
            int sourceLength = source.remaining();
            length = Math.min(sourceLength, sink.remaining());
            int sourceLimit = source.limit();
            source.limit(source.position() + length);
            sink.put(source);
            source.limit(sourceLimit);
            BufferUtil.flipToFlush((ByteBuffer)sink, (int)sinkPosition);
        }
        return length;
    }

    public boolean flush(ByteBuffer ... buffers) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {} on {}", (Object)BufferUtil.toDetailString((ByteBuffer[])buffers), (Object)this);
        }
        if (buffers == null || buffers.length == 0 || BufferUtil.remaining((ByteBuffer[])buffers) == 0L) {
            return true;
        }
        switch (this.writeState.get().ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                throw new EofException("output shutdown");
            }
            case 4: {
                throw IO.rethrow((Throwable)this.writeFailure.get());
            }
        }
        return false;
    }

    public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
        this.write(false, List.of(buffers), callback);
    }

    public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
        this.write(last, List.of(byteBuffer), callback);
    }

    public Callback cancelWrite(Throwable cause) {
        throw new UnsupportedOperationException();
    }

    public void write(boolean last, List<ByteBuffer> buffers, final Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing {} on {}", (Object)BufferUtil.toDetailString((ByteBuffer[])((ByteBuffer[])buffers.toArray(ByteBuffer[]::new))), (Object)this);
        }
        if (buffers != null && !buffers.isEmpty() && this.remaining(buffers) != 0L) {
            block6: while (true) {
                WriteState current = this.writeState.get();
                switch (current.ordinal()) {
                    case 0: {
                        if (!this.writeState.compareAndSet(current, WriteState.PENDING)) continue block6;
                        this.stream.data(last, buffers, (Promise.Invocable)new Promise.Invocable.Abstract<Stream>(this, callback.getInvocationType()){
                            final /* synthetic */ StreamEndPoint this$0;
                            {
                                this.this$0 = this$0;
                                super(arg0);
                            }

                            public void succeeded(Stream result) {
                                this.this$0.writeSuccess(callback);
                            }

                            public void failed(Throwable x) {
                                this.this$0.writeFailure(x, callback);
                            }
                        });
                        break block6;
                    }
                    case 1: {
                        callback.failed((Throwable)new WritePendingException());
                        break block6;
                    }
                    case 2: 
                    case 3: {
                        callback.failed((Throwable)new EofException("output shutdown"));
                        break block6;
                    }
                    case 4: {
                        callback.failed(this.writeFailure.get());
                        break block6;
                    }
                    default: {
                        callback.failed((Throwable)new IllegalStateException("unexpected state: " + String.valueOf((Object)current)));
                    }
                }
                break;
            }
            return;
        }
        callback.succeeded();
    }

    private long remaining(List<ByteBuffer> buffers) {
        long remaining = 0L;
        for (ByteBuffer buffer : buffers) {
            remaining += (long)buffer.remaining();
        }
        return remaining;
    }

    private void writeSuccess(Callback callback) {
        block5: while (true) {
            WriteState current = this.writeState.get();
            switch (current.ordinal()) {
                case 1: {
                    if (!this.writeState.compareAndSet(current, WriteState.IDLE)) continue block5;
                    callback.succeeded();
                    break block5;
                }
                case 2: {
                    callback.succeeded();
                    this.shutdownOutput();
                    break block5;
                }
                case 4: {
                    callback.failed(this.writeFailure.get());
                    break block5;
                }
                default: {
                    callback.failed((Throwable)new IllegalStateException("unexpected state: " + String.valueOf((Object)current)));
                }
            }
            break;
        }
    }

    private void writeFailure(Throwable failure, Callback callback) {
        block4: while (true) {
            WriteState current = this.writeState.get();
            switch (current.ordinal()) {
                case 1: 
                case 2: {
                    this.writeFailure.compareAndSet(null, failure);
                    if (!this.writeState.compareAndSet(current, WriteState.FAILED)) continue block4;
                    callback.failed(failure);
                    break block4;
                }
                case 4: {
                    break block4;
                }
                default: {
                    callback.failed((Throwable)new IllegalStateException("unexpected state: " + String.valueOf((Object)current)));
                }
            }
            break;
        }
    }

    public boolean isFillInterested() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.fillInterest != null;
            return bl;
        }
    }

    public void fillInterested(Callback callback) {
        if (!this.tryFillInterested(callback)) {
            throw new ReadPendingException();
        }
    }

    public boolean tryFillInterested(Callback callback) {
        boolean set;
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = set = this.fillInterest == null;
            if (set) {
                this.fillInterest = callback;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting ({}) fill interest with {} on {}", new Object[]{set, callback, this});
        }
        if (set) {
            this.stream.demand();
        }
        return set;
    }

    void fillable() {
        Callback callback;
        try (AutoLock ignored = this.lock.lock();){
            callback = this.fillInterest;
            this.fillInterest = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifying fillable via {} on {}", (Object)callback, (Object)this);
        }
        if (callback != null) {
            callback.succeeded();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("opened {}", (Object)this);
        }
    }

    public void upgrade(Connection newConnection) {
        Connection oldConnection = this.getConnection();
        ByteBuffer byteBuffer = null;
        if (oldConnection instanceof Connection.UpgradeFrom) {
            Connection.UpgradeFrom from = (Connection.UpgradeFrom)oldConnection;
            byteBuffer = from.onUpgradeFrom();
        }
        oldConnection.onClose(null);
        this.setConnection(newConnection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} upgrading from {} to {} with {}", new Object[]{this, oldConnection, newConnection, BufferUtil.toDetailString((ByteBuffer)byteBuffer)});
        }
        if (BufferUtil.hasContent((ByteBuffer)byteBuffer)) {
            if (newConnection instanceof Connection.UpgradeTo) {
                Connection.UpgradeTo to = (Connection.UpgradeTo)newConnection;
                to.onUpgradeTo(byteBuffer);
            } else {
                throw new IllegalStateException("Cannot upgrade: " + String.valueOf(newConnection) + " does not implement " + Connection.UpgradeTo.class.getName());
            }
        }
        newConnection.onOpen();
    }

    public EndPoint.SslSessionData getSslSessionData() {
        AbstractSession session = (AbstractSession)this.stream.getSession();
        X509Certificate[] peerCertificates = session.getPeerCertificates();
        return EndPoint.SslSessionData.from(null, null, null, (X509Certificate[])peerCertificates);
    }

    private String toConnectionString() {
        Connection connection = this.getConnection();
        if (connection == null) {
            return "<null>";
        }
        if (connection instanceof AbstractConnection) {
            AbstractConnection c = (AbstractConnection)connection;
            return c.toConnectionString();
        }
        return "%s@%x".formatted(TypeUtil.toShortName((Class)connection.getClass()), connection.hashCode());
    }

    public String toString() {
        return String.format("%s@%x#%d[d=%s,%s]", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getStream().getId(), this.chunk, this.toConnectionString());
    }

    private static enum WriteState {
        IDLE,
        PENDING,
        CLOSING,
        CLOSED,
        FAILED;

    }
}

