/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.http3.HTTP3Configuration;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.parser.MessageParser;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3Session;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3StreamConnection;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;

public abstract class AbstractHTTP3ServerConnectionFactory
extends AbstractConnectionFactory
implements ProtocolSession.Factory,
ConnectionFactory.Configuring {
    private final HTTP3Configuration http3Configuration = new HTTP3Configuration();
    private final HttpConfiguration httpConfiguration;
    private final Session.Server.Listener listener;
    private Connector connector;

    public AbstractHTTP3ServerConnectionFactory(HttpConfiguration httpConfiguration, Session.Server.Listener listener) {
        super("h3");
        this.httpConfiguration = Objects.requireNonNull(httpConfiguration);
        this.listener = listener;
        this.http3Configuration.setUseInputDirectByteBuffers(httpConfiguration.isUseInputDirectByteBuffers());
        this.http3Configuration.setUseOutputDirectByteBuffers(httpConfiguration.isUseOutputDirectByteBuffers());
        this.http3Configuration.setMaxRequestHeadersSize(httpConfiguration.getRequestHeaderSize());
        int maxResponseHeaderSize = httpConfiguration.getMaxResponseHeaderSize();
        if (maxResponseHeaderSize < 0) {
            maxResponseHeaderSize = this.getHttpConfiguration().getResponseHeaderSize();
        }
        this.http3Configuration.setMaxResponseHeadersSize(maxResponseHeaderSize);
        this.http3Configuration.setInputBufferSize(httpConfiguration.getInputBufferSize());
        this.setInputBufferSize(this.http3Configuration.getInputBufferSize());
    }

    public void setInputBufferSize(int size) {
        super.setInputBufferSize(size);
        this.httpConfiguration.setInputBufferSize(size);
        this.http3Configuration.setInputBufferSize(size);
    }

    public int getInputBufferSize() {
        return this.httpConfiguration.getInputBufferSize();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public HTTP3Configuration getHTTP3Configuration() {
        return this.http3Configuration;
    }

    public void configure(Connector connector) {
        this.connector = connector;
    }

    protected void doStart() throws Exception {
        this.addBean(this.http3Configuration);
        this.addBean(this.httpConfiguration);
        super.doStart();
    }

    public ProtocolSession newProtocolSession(Session quicSession, Map<String, Object> context) {
        return new ServerHTTP3Session(this.connector, quicSession, (ConnectionFactory)this, this.getHTTP3Configuration(), this.listener);
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        StreamEndPoint streamEndPoint = (StreamEndPoint)endPoint;
        long streamId = streamEndPoint.getStream().getId();
        ServerHTTP3Session http3Session = (ServerHTTP3Session)streamEndPoint.getProtocolSession();
        MessageParser parser = new MessageParser(http3Session.getSessionServer().getParserListener(), http3Session.getQpackDecoder(), streamId);
        ServerHTTP3StreamConnection connection = new ServerHTTP3StreamConnection(connector, this.getHttpConfiguration(), streamEndPoint, http3Session, parser);
        return this.configure((AbstractConnection)connection, connector, endPoint);
    }
}

