/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.webapi.groups;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.search.SearchResultEntry;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;

@JsonData
@Schema(description="A list of user groups with basic information about each matching group. The list is filtered based on the search query and user permissions.", title="Groups List Response", example="[{\"id\":\"550e8400-e29b-41d4-a716-446655440000\",\"type\":\"STATIC_GROUP\",\"displayName\":\"Administrators\"}]")
public class GroupsListResponseData
extends ArrayList<Entry> {
    private GroupsListResponseData() {
    }

    public static GroupsListResponseData from(List<SearchResultEntry<GUID>> entries) {
        GroupsListResponseData groupsListResponseData = new GroupsListResponseData();
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        for (SearchResultEntry<GUID> searchResultEntry : entries) {
            groupsListResponseData.add(Entry.from(userGroupManager.getGroup((GUID)searchResultEntry.getId())));
        }
        return groupsListResponseData;
    }

    @JsonData
    @Schema(description="Basic information about a user group.", title="Group Entry", example="{\"id\":\"550e8400-e29b-41d4-a716-446655440000\",\"type\":\"STATIC_GROUP\",\"displayName\":\"Administrators\"}")
    static class Entry {
        @Schema(description="The unique identifier (GUID) of the group", example="550e8400-e29b-41d4-a716-446655440000", required=true)
        private GUID id;
        @Schema(description="The type of group (e.g., STATIC_GROUP, DYNAMIC_GROUP, etc.)", example="STATIC_GROUP", required=true)
        private String type;
        @Schema(description="The human-readable display name of the group", example="Administrators", required=true)
        private String displayName;

        Entry() {
        }

        public static Entry from(UserGroupInfo groupInfo) {
            Entry entry = new Entry();
            entry.id = groupInfo.getID();
            entry.type = groupInfo.getType().getName();
            entry.displayName = groupInfo.getDisplayName();
            return entry;
        }
    }
}

