/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.webapi.users;

import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.plugin.webapi.api.handler.RequestHandlerWithGUIDPathToken;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroupsmanager.server.webapi.users.UserIDRequestData;
import com.inet.usersandgroupsmanager.server.webapi.users.UserIDResponseData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nullable;

@Description(description="Request details of a user. With only an empty list, all available fields are returned.", summary="Request user details.")
@Tag(name="Users", description="User management and search operations")
public class a
extends RequestHandlerWithGUIDPathToken<UserIDRequestData, UserIDResponseData> {
    public a() {
        super(new String[]{"user"});
    }

    public String getHelpPageKey() {
        return "usersandgroups.webapi.users.id";
    }

    @Operation(summary="Get user details by ID", description="Retrieves detailed information about a specific user by their ID. The user ID must be a valid GUID. If no specific fields are requested in the input, all available fields will be returned.", parameters={@Parameter(name="userId", description="The GUID of the user to retrieve", required=true, schema=@Schema(implementation=GUID.class, example="000aIG6b0IaRVqazNR3j6Jelg"))}, responses={@ApiResponse(responseCode="200", description="Successfully retrieved user details", content={@Content(schema=@Schema(implementation=UserIDResponseData.class))}), @ApiResponse(responseCode="404", description="User not found or access denied"), @ApiResponse(responseCode="400", description="Invalid user ID format")})
    public UserIDResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable UserIDRequestData userIDRequestData, @Nullable GUID gUID, boolean bl) throws IOException {
        UserAccount userAccount = UserManager.getInstance().getUserAccountAsUser(gUID);
        if (userAccount == null) {
            throw new ClientMessageException(com.inet.usersandgroupsmanager.server.webapi.a.MSG.getMsg("user.id.doesNotExist", new Object[]{gUID}));
        }
        return UserIDResponseData.from(userAccount, userIDRequestData);
    }

    @Operation(summary="Get user details by ID", description="Retrieves detailed information about a specific user by their ID. The user ID must be a valid GUID. If no specific fields are requested in the input, all available fields will be returned.", parameters={@Parameter(name="userId", description="The GUID of the user to retrieve", required=true, schema=@Schema(implementation=GUID.class, example="000aIG6b0IaRVqazNR3j6Jelg"))}, responses={@ApiResponse(responseCode="200", description="Successfully retrieved user details", content={@Content(schema=@Schema(implementation=UserIDResponseData.class))}), @ApiResponse(responseCode="404", description="User not found or access denied"), @ApiResponse(responseCode="400", description="Invalid user ID format")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (UserIDRequestData)object, (GUID)object2, bl);
    }
}

