/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.webapi.users;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.search.SearchResultEntry;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;

@JsonData
@Schema(description="A user list response data containing basic information about each matching user. The list is filtered based on the search query and user permissions.", title="Users List Response", example="[{\"id\":\"550e8400-e29b-41d4-a716-446655440000\",\"type\":\"USER\",\"displayName\":\"John Doe\"}]")
public class UsersListResponseData
extends ArrayList<Entry> {
    private UsersListResponseData() {
    }

    public static UsersListResponseData from(List<SearchResultEntry<GUID>> entries) {
        UsersListResponseData usersListResponseData = new UsersListResponseData();
        UserManager userManager = UserManager.getInstance();
        for (SearchResultEntry<GUID> searchResultEntry : entries) {
            usersListResponseData.add(Entry.from(userManager.getUserAccount((GUID)searchResultEntry.getId())));
        }
        return usersListResponseData;
    }

    @JsonData
    @Schema(description="Basic information about a user account.", title="User Entry", example="{\"id\":\"550e8400-e29b-41d4-a716-446655440000\",\"type\":\"USER\",\"displayName\":\"John Doe\"}")
    static class Entry {
        @Schema(description="The unique identifier (GUID) of the user", example="550e8400-e29b-41d4-a716-446655440000", required=true)
        private GUID id;
        @Schema(description="The type of user account (e.g., USER, SYSTEM, etc.)", example="USER", required=true)
        private String type;
        @Schema(description="The human-readable display name of the user", example="John Doe", required=true)
        private String displayName;

        Entry() {
        }

        public static Entry from(UserAccount userAccount) {
            Entry entry = new Entry();
            entry.id = userAccount.getID();
            entry.type = userAccount.getAccountType().name();
            entry.displayName = userAccount.getDisplayName();
            return entry;
        }
    }
}

