/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.webapi.groups;

import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.plugin.webapi.api.handler.RequestHandlerWithGUIDPathToken;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroupsmanager.server.webapi.groups.GroupIDRequestData;
import com.inet.usersandgroupsmanager.server.webapi.groups.GroupIDResponseData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nullable;

@Description(description="Request detail information about a user group. You have to provide a valid group ID. Additional fields will be sent only on request.", summary="User Group Details.")
@Tag(name="Groups", description="Group management and search operations")
public class a
extends RequestHandlerWithGUIDPathToken<GroupIDRequestData, GroupIDResponseData> {
    public a() {
        super(new String[]{"group"});
    }

    public String getHelpPageKey() {
        return "usersandgroups.webapi.groups.id";
    }

    @Operation(summary="Get group details by ID", description="Retrieves detailed information about a specific group by its ID. The group ID must be a valid GUID. If no specific fields are requested in the input, all available fields will be returned. Only accessible if the group exists and the user has sufficient permissions.", parameters={@Parameter(name="groupId", description="The GUID of the group to retrieve", required=true, schema=@Schema(implementation=GUID.class, example="000aIG6b0IaRVqazNR3j6Jelg"))}, responses={@ApiResponse(responseCode="200", description="Successfully retrieved group details", content={@Content(schema=@Schema(implementation=GroupIDResponseData.class))}), @ApiResponse(responseCode="404", description="Group not found or access denied"), @ApiResponse(responseCode="400", description="Invalid group ID format")})
    public GroupIDResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable GroupIDRequestData groupIDRequestData, @Nullable GUID gUID, boolean bl) throws IOException {
        UserGroupInfo userGroupInfo = UserGroupManager.getInstance().getGroup(gUID);
        if (userGroupInfo == null) {
            throw new ClientMessageException(com.inet.usersandgroupsmanager.server.webapi.a.MSG.getMsg("group.id.doesNotExist", new Object[]{gUID}));
        }
        return GroupIDResponseData.from(userGroupInfo, groupIDRequestData);
    }

    @Operation(summary="Get group details by ID", description="Retrieves detailed information about a specific group by its ID. The group ID must be a valid GUID. If no specific fields are requested in the input, all available fields will be returned. Only accessible if the group exists and the user has sufficient permissions.", parameters={@Parameter(name="groupId", description="The GUID of the group to retrieve", required=true, schema=@Schema(implementation=GUID.class, example="000aIG6b0IaRVqazNR3j6Jelg"))}, responses={@ApiResponse(responseCode="200", description="Successfully retrieved group details", content={@Content(schema=@Schema(implementation=GroupIDResponseData.class))}), @ApiResponse(responseCode="404", description="Group not found or access denied"), @ApiResponse(responseCode="400", description="Invalid group ID format")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (GroupIDRequestData)object, (GUID)object2, bl);
    }
}

