/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.handler;

import com.inet.config.ConfigValue;
import com.inet.http.ClientMessageException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.Hash;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.GroupDeletionHandler;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroupsmanager.UsersAndGroupsManagerServerPlugin;
import com.inet.usersandgroupsmanager.server.data.ReactivateUserRequestData;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

public class b
extends ServiceMethod<ReactivateUserRequestData, Void> {
    private static final ConfigValue<Boolean> e = new ConfigValue(UsersAndGroupsManagerServerPlugin.CONFIGKEY_USER_CAN_DELETE_THEMSELF);
    private static final ConfigValue<Boolean> f = new ConfigValue(UsersAndGroupsManagerServerPlugin.CONFIGKEY_DELETE_USERS_IN_MANAGER);

    public String getMethodName() {
        return "usersandgroupsmanager_delete";
    }

    public short getMethodType() {
        return 1;
    }

    public Void a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, ReactivateUserRequestData reactivateUserRequestData) throws ClientMessageException {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.notloggedin", new Object[0]));
        }
        Hash hash = reactivateUserRequestData.getHash();
        if (!hash.getId().equals((Object)userAccount.getID()) && !SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
            throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.actionnotallowed", new Object[0]));
        }
        if (hash.getType() == Type.user) {
            if (hash.getId().equals((Object)userAccount.getID()) && !SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN) && !((Boolean)e.get()).booleanValue()) {
                throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.actionnotallowed", new Object[0]));
            }
            if (!((Boolean)f.get()).booleanValue()) {
                throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.actionnotallowed", new Object[0]));
            }
        }
        if (hash.getType() == Type.user) {
            UserManager userManager = UserManager.getRecoveryEnabledInstance();
            try {
                userManager.deleteUserAccount(hash.getId());
                return null;
            }
            catch (Throwable throwable) {
                UsersAndGroups.LOGGER.error(throwable);
                throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.deletionfailed", new Object[]{throwable.getMessage()}));
            }
        }
        if (hash.getType() == Type.group) {
            UserGroupManager userGroupManager = UserGroupManager.getRecoveryEnabledInstance();
            UserGroupInfo userGroupInfo = userGroupManager.getGroup(hash.getId());
            if (userGroupInfo != null) {
                try {
                    List list = ServerPluginManager.getInstance().get(GroupDeletionHandler.class);
                    for (GroupDeletionHandler groupDeletionHandler : list) {
                        if (groupDeletionHandler.getGroupType() != userGroupInfo.getType()) continue;
                        groupDeletionHandler.performDeletion(userGroupInfo, reactivateUserRequestData.getProperties());
                        return null;
                    }
                    userGroupManager.deleteGroup(hash.getId());
                }
                catch (Throwable throwable) {
                    UsersAndGroups.LOGGER.error(throwable);
                    throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.deletionfailed", new Object[]{throwable.getMessage()}));
                }
            }
            return null;
        }
        return null;
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ReactivateUserRequestData)object);
    }
}

