/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.data;

import com.inet.annotations.JsonData;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.ui.fields.MembershipTypeDescription;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Set;

@JsonData
public class GroupTypeDescription {
    private String displayName;
    private String createLabel;
    private String description;
    private boolean creatable;
    private boolean deactivatable;
    private boolean deletable;
    private int priority;
    private boolean showDisplayNameInList;
    private ArrayList<MembershipTypeDescription> types = new ArrayList();
    private String cardinality;

    public GroupTypeDescription(int priority, String displayName, String createLabel, String description, boolean showDisplayNameInList, ArrayList<MembershipTypeDescription> types, String cardinality, boolean creatable, boolean deactivatable, boolean deletable) {
        this.priority = priority;
        this.displayName = displayName;
        this.createLabel = createLabel;
        this.description = description;
        this.showDisplayNameInList = showDisplayNameInList;
        this.types = types;
        this.cardinality = cardinality;
        this.creatable = creatable;
        this.deactivatable = deactivatable;
        this.deletable = deletable;
    }

    public GroupTypeDescription(UserAccountType accountType) {
        this(accountType.ordinal(), accountType.getDisplayName(), accountType.getCreateLabel(), accountType.getDescription(), accountType == UserAccountType.Standard, null, null, accountType == UserAccountType.Standard, accountType == UserAccountType.Standard, accountType == UserAccountType.Standard || accountType == UserAccountType.Guest);
    }

    public GroupTypeDescription(GroupTypeDef definition) {
        this(definition.getPriority(), definition.getDisplayName(), definition.getCreateLabel(), definition.getDescription(), !definition.isSystemGroup(), GroupTypeDescription.getMembershipTypes(definition), definition.getMemberToTypeCardinality().toString(), GroupTypeDescription.iscreatable(definition), GroupTypeDescription.isdeactivatable(definition), GroupTypeDescription.isdeletable(definition));
    }

    private static boolean iscreatable(GroupTypeDef definition) {
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)UserManager.getInstance().getCurrentUserAccount(), (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN})) {
            return false;
        }
        return !definition.isRestrictedBy(GroupTypeDef.GroupTypeRestrictions.PreventCreation);
    }

    private static boolean isdeactivatable(GroupTypeDef definition) {
        return false;
    }

    private static boolean isdeletable(GroupTypeDef definition) {
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)UserManager.getInstance().getCurrentUserAccount(), (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN})) {
            return false;
        }
        return !definition.isRestrictedBy(GroupTypeDef.GroupTypeRestrictions.PreventRemoval);
    }

    private static ArrayList<MembershipTypeDescription> getMembershipTypes(GroupTypeDef definition) {
        ArrayList<MembershipTypeDescription> arrayList = new ArrayList<MembershipTypeDescription>();
        Set set = definition.getMembershipTypes();
        for (MembershipType membershipType : set) {
            arrayList.add(new MembershipTypeDescription(membershipType.getKey(), membershipType.getDisplayName(), definition.getGroupType().getName()));
        }
        if (set.isEmpty()) {
            arrayList.add(new MembershipTypeDescription("", "", definition.getGroupType().getName()));
        }
        return arrayList;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCreatable() {
        return this.creatable;
    }

    public boolean isDeactivatable() {
        return this.deactivatable;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public boolean isShowDisplayNameInList() {
        return this.showDisplayNameInList;
    }

    public ArrayList<MembershipTypeDescription> getTypes() {
        return this.types;
    }
}

