/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.webapi.groups;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroupsmanager.server.webapi.groups.GroupIDRequestData;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@JsonData
@Schema(description="The user group response for a detailed request. Additional fields can be provided.", title="Group Details Response", example="{\"id\":\"000aIG6b0IaRVqazNR3j6Jelg\",\"displayName\":\"Administrators\",\"type\":\"STATIC_GROUP\",\"fields\":{\"description\":\"System administrators group\",\"memberCount\":5},\"availableFields\":[\"description\",\"memberCount\",\"createdDate\"]}")
public class GroupIDResponseData {
    @Schema(description="The GUID of the group", example="000aIG6b0IaRVqazNR3j6Jelg", required=true)
    private String id;
    @Schema(description="The display name of the group", example="Administrators", required=true)
    private String displayName;
    @Schema(description="The type of group", example="STATIC_GROUP", required=true)
    private String type;
    @Schema(description="Additional group fields that were specifically requested", example="{\"description\":\"System administrators group\",\"memberCount\":5}", required=false)
    @JsonExcludeNull
    private Map<String, Object> fields;
    @Schema(description="List of field names that can be requested for this group. Only returned when the query has an empty fields list.", example="[\"description\",\"memberCount\",\"createdDate\"]", required=false)
    @JsonExcludeNull
    @Description(description="An optional list of field names that can be requested for this type. Will be returned only, when the query has a `fields = []` property.")
    private List<@Nonnull String> availableFields;

    public static GroupIDResponseData from(UserGroupInfo groupInfo, GroupIDRequestData requestedFields) {
        GroupIDResponseData groupIDResponseData = new GroupIDResponseData();
        groupIDResponseData.displayName = groupInfo.getDisplayName();
        groupIDResponseData.type = groupInfo.getType().getName();
        Set set = groupInfo.getIncludedFields();
        if (!SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
            set.clear();
        }
        if (requestedFields != null && !requestedFields.getFields().isEmpty()) {
            List<String> list = requestedFields.getFields();
            set.removeIf(f2 -> !list.contains(f2.getKey()));
            for (UserGroupField userGroupField : set) {
                groupIDResponseData.addField(userGroupField.getKey(), groupInfo.getValue(userGroupField));
            }
        } else if (requestedFields != null) {
            groupIDResponseData.availableFields = set.stream().map(f2 -> f2.getKey()).collect(Collectors.toList());
        }
        return groupIDResponseData;
    }

    private void addField(String key, Object value) {
        if (this.fields == null) {
            this.fields = new HashMap<String, Object>();
        }
        this.fields.put(key, value);
    }
}

