/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.handler;

import com.inet.authentication.base.LoginManager;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldValidationException;
import com.inet.usersandgroups.api.Hash;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.UserGroupUpdateData;
import com.inet.usersandgroups.api.ui.fields.UserUpdateData;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.fields.FieldEmail;
import com.inet.usersandgroupsmanager.UsersAndGroupsManagerServerPlugin;
import com.inet.usersandgroupsmanager.server.data.Grouping;
import com.inet.usersandgroupsmanager.server.data.SaveUserOrGroupRequestData;
import com.inet.usersandgroupsmanager.server.data.SaveUserOrGroupResponseData;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class m
extends ServiceMethod<SaveUserOrGroupRequestData, SaveUserOrGroupResponseData> {
    public String getMethodName() {
        return "usersandgroupsmanager_save";
    }

    public short getMethodType() {
        return 1;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public SaveUserOrGroupResponseData a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, SaveUserOrGroupRequestData saveUserOrGroupRequestData) throws ClientMessageException {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.notloggedin", new Object[0]));
        }
        Hash hash = saveUserOrGroupRequestData.getHash();
        if (hash.getType() == Type.group && !SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
            AccessDeniedException accessDeniedException = new AccessDeniedException(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
            throw new ClientMessageException(accessDeniedException.getMessage(), (Throwable)accessDeniedException);
        }
        if (hash.getType() == Type.user && !hash.getId().equals((Object)userAccount.getID()) && !SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS)) {
            AccessDeniedException accessDeniedException = new AccessDeniedException(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS);
            throw new ClientMessageException(accessDeniedException.getMessage(), (Throwable)accessDeniedException);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            FieldDefinition fieldDefinition;
            Object object5;
            UserUpdateData userUpdateData;
            UserAccount userAccount2;
            Grouping grouping = saveUserOrGroupRequestData.getCreateGrouping();
            HashMap<String, String> hashMap = saveUserOrGroupRequestData.getValues();
            UserManager userManager = UserManager.getRecoveryEnabledInstance();
            UserGroupManager userGroupManager = UserGroupManager.getRecoveryEnabledInstance();
            @Nonnull List list = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
            if (hash.getType() == Type.user) {
                userAccount2 = null;
                if (grouping == null && (userAccount2 = userManager.getUserAccount(hash.getId())) == null) {
                    throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.notfound.user", new Object[0]));
                }
                userUpdateData = new UserUpdateData();
                object5 = list.iterator();
                while (object5.hasNext()) {
                    fieldDefinition = (FieldDefinition)object5.next();
                    if (fieldDefinition.getGroupingType() != hash.getType() || !(fieldDefinition instanceof UserFieldDefinition) || !hashMap.containsKey(fieldDefinition.getFieldKey())) continue;
                    object4 = (UserFieldDefinition)fieldDefinition;
                    object3 = object4.convertFromString(hashMap.get(fieldDefinition.getFieldKey()));
                    object4.validate(object3);
                    if (object4.isAvailable(userAccount2) && object4.getEditability().isEditable()) {
                        object4.save(userAccount2, userUpdateData, object3);
                        continue;
                    }
                    object2 = UsersAndGroups.getFieldByKey((String)fieldDefinition.getFieldKey());
                    if (object2 == null || object2 instanceof FieldEmail || Objects.equals(object = userAccount2 != null ? userAccount2.getValue((UserField)object2) : object2.getDefaultValue(), object3)) continue;
                    throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.field.accessdenied", new Object[]{object2.getLabel()}));
                }
                if (!(userUpdateData.getGroupsToAddUserTo().isEmpty() && userUpdateData.getGroupsToRemoveUserFrom().isEmpty() && userUpdateData.getAddedPermissions().isEmpty() && userUpdateData.getRemovedPermissions().isEmpty() || SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN))) {
                    throw new AccessDeniedException(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
                }
                if (!(userAccount.getID().equals((Object)hash.getId()) || userUpdateData.getAddedLoginSettings().isEmpty() && userUpdateData.getRemovedLoginSettings().isEmpty() || SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN))) {
                    throw new AccessDeniedException(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
                }
                if (!SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
                    if (SystemPermissionChecker.hasAnyPermission((GUID)hash.getId(), (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN})) {
                        throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.error.userwithhigherpermissioncannotbechanged", new Object[0]));
                    }
                    if (!SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION) && SystemPermissionChecker.hasAnyPermission((GUID)hash.getId(), (Permission[])new Permission[]{Permission.CONFIGURATION})) {
                        throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.error.userwithhigherpermissioncannotbechanged", new Object[0]));
                    }
                }
                if (grouping != null) {
                    object5 = userManager.createUserAccount(UserAccountType.valueOf((String)grouping.getKey()), userUpdateData.getUserData());
                    try {
                        if (!userUpdateData.getAddedLoginSettings().isEmpty() || !userUpdateData.getRemovedLoginSettings().isEmpty()) {
                            userManager.updateLoginSettings(object5.getID(), userUpdateData.getAddedLoginSettings(), userUpdateData.getRemovedLoginSettings());
                        }
                        if (!userUpdateData.getAddedPermissions().isEmpty() || !userUpdateData.getRemovedPermissions().isEmpty()) {
                            userManager.updateUserPermissions(object5.getID(), userUpdateData.getAddedPermissions(), userUpdateData.getRemovedPermissions());
                        }
                        if (!userUpdateData.getGroupsToAddUserTo().isEmpty() || !userUpdateData.getGroupsToRemoveUserFrom().isEmpty()) {
                            userGroupManager.updateUserGroupMembership(object5.getID(), userUpdateData.getGroupsToAddUserTo(), userUpdateData.getGroupsToRemoveUserFrom());
                        }
                        hash = new Hash(Type.user, object5.getID());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        userManager.deleteUserAccount(object5.getID());
                        throw illegalArgumentException;
                    }
                } else if (userAccount2 != null) {
                    if (!saveUserOrGroupRequestData.isConfirmed()) {
                        if (SystemPermissionChecker.isSystemPermissionsEnabled() && SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN}) && userAccount2.equals(userAccount) && (object5 = this.a(userGroupManager, userAccount2, userUpdateData)) != null) {
                            return object5;
                        }
                        if (userAccount2.getAccountType() == UserAccountType.Guest && (object5 = this.b(userGroupManager, userAccount2, userUpdateData)) != null) {
                            return object5;
                        }
                    }
                    if (!userUpdateData.getUserData().isEmpty()) {
                        userManager.updateUserData(userAccount2.getID(), userUpdateData.getUserData());
                    }
                    if (!userUpdateData.getAddedLoginSettings().isEmpty() || !userUpdateData.getRemovedLoginSettings().isEmpty()) {
                        userManager.updateLoginSettings(userAccount2.getID(), userUpdateData.getAddedLoginSettings(), userUpdateData.getRemovedLoginSettings());
                    }
                    if (!userUpdateData.getAddedPermissions().isEmpty() || !userUpdateData.getRemovedPermissions().isEmpty()) {
                        userManager.updateUserPermissions(userAccount2.getID(), userUpdateData.getAddedPermissions(), userUpdateData.getRemovedPermissions());
                    }
                    if (!userUpdateData.getGroupsToAddUserTo().isEmpty() || !userUpdateData.getGroupsToRemoveUserFrom().isEmpty()) {
                        userGroupManager.updateUserGroupMembership(userAccount2.getID(), userUpdateData.getGroupsToAddUserTo(), userUpdateData.getGroupsToRemoveUserFrom());
                    }
                }
            }
            if (hash.getType() == Type.group) {
                if (!SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
                    throw new AccessDeniedException(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
                }
                userAccount2 = null;
                if (!(grouping != null || (userAccount2 = userGroupManager.getGroup(hash.getId())) != null && userAccount2.isActive())) {
                    throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.notfound.group", new Object[0]));
                }
                userUpdateData = new UserGroupUpdateData();
                object5 = list.iterator();
                while (object5.hasNext()) {
                    fieldDefinition = (FieldDefinition)object5.next();
                    if (fieldDefinition.getGroupingType() != hash.getType() || !(fieldDefinition instanceof GroupFieldDefinition) || !hashMap.containsKey(fieldDefinition.getFieldKey())) continue;
                    object4 = (GroupFieldDefinition)fieldDefinition;
                    object3 = object4.convertFromString(hashMap.get(fieldDefinition.getFieldKey()));
                    object4.validate(object3);
                    object4.save((UserGroupInfo)userAccount2, (UserGroupUpdateData)userUpdateData, object3);
                }
                if (grouping != null) {
                    object5 = userUpdateData.getParentID();
                    fieldDefinition = userGroupManager.createGroup((GUID)object5, userUpdateData.getName(), GroupType.of((String)grouping.getKey()), userUpdateData.getUserGroupData());
                    if (!saveUserOrGroupRequestData.isConfirmed()) {
                        object4 = userUpdateData.getMembersToAdd().keySet();
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            SaveUserOrGroupResponseData saveUserOrGroupResponseData;
                            object2 = (GUID)object3.next();
                            object = userManager.getUserAccount((GUID)object2);
                            if (object.getAccountType() != UserAccountType.Guest || (saveUserOrGroupResponseData = this.b(userGroupManager, (UserAccount)object, (UserGroupUpdateData)userUpdateData, null)) == null) continue;
                            userGroupManager.deleteGroup((GUID)fieldDefinition);
                            return saveUserOrGroupResponseData;
                        }
                    }
                    try {
                        if (!userUpdateData.getAddedPermissions().isEmpty() || !userUpdateData.getRemovedPermissions().isEmpty()) {
                            userGroupManager.updateGroupPermissions((GUID)fieldDefinition, userUpdateData.getAddedPermissions(), userUpdateData.getRemovedPermissions());
                        }
                        if (!userUpdateData.getMembersToAdd().isEmpty() || !userUpdateData.getMembersToRemove().isEmpty()) {
                            userGroupManager.updateGroupMembers((GUID)fieldDefinition, userUpdateData.getMembersToAdd(), userUpdateData.getMembersToRemove());
                        }
                        hash = new Hash(Type.group, (GUID)fieldDefinition);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        userGroupManager.deleteGroup((GUID)fieldDefinition);
                        throw illegalArgumentException;
                    }
                } else if (userAccount2 != null) {
                    if (!saveUserOrGroupRequestData.isConfirmed()) {
                        if (SystemPermissionChecker.isSystemPermissionsEnabled() && SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN}) && (object5 = this.a(userGroupManager, userAccount, (UserGroupUpdateData)userUpdateData, (UserGroupInfo)userAccount2)) != null) {
                            return object5;
                        }
                        if (LoginManager.isGuestAccount() && UsersAndGroups.GROUPTYPE_ALLUSERS.equals((Object)userAccount2.getType()) && (object5 = this.b(userGroupManager, null, (UserGroupUpdateData)userUpdateData, (UserGroupInfo)userAccount2)) != null) {
                            return object5;
                        }
                        object5 = new HashSet(userAccount2.getMemberIDs());
                        object5.removeAll(userUpdateData.getMembersToRemove().keySet());
                        object5.addAll(userUpdateData.getMembersToAdd().keySet());
                        if (object5.size() > 0) {
                            fieldDefinition = new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Equals, (Object)UserAccountType.Guest.name());
                            object4 = new SearchCommand(new SearchExpression[]{fieldDefinition});
                            object3 = userManager.getSearchEngine().simpleSearch((SearchCommand)object4);
                            object5.retainAll((Collection<?>)object3);
                            if (object5.size() > 0) {
                                object2 = object5.iterator();
                                while (object2.hasNext()) {
                                    object = (GUID)object2.next();
                                    UserAccount userAccount3 = userManager.getUserAccount((GUID)object);
                                    SaveUserOrGroupResponseData saveUserOrGroupResponseData = this.b(userGroupManager, userAccount3, (UserGroupUpdateData)userUpdateData, (UserGroupInfo)userAccount2);
                                    if (saveUserOrGroupResponseData == null) continue;
                                    return saveUserOrGroupResponseData;
                                }
                            }
                        }
                    }
                    if (userUpdateData.getName() != null && !userUpdateData.getName().equals(userAccount2.getName())) {
                        userGroupManager.renameGroup(userAccount2.getID(), userUpdateData.getName());
                    }
                    if (!userUpdateData.getUserGroupData().isEmpty()) {
                        userGroupManager.updateGroupData(userAccount2.getID(), userUpdateData.getUserGroupData());
                    }
                    if (!userUpdateData.getAddedPermissions().isEmpty() || !userUpdateData.getRemovedPermissions().isEmpty()) {
                        userGroupManager.updateGroupPermissions(userAccount2.getID(), userUpdateData.getAddedPermissions(), userUpdateData.getRemovedPermissions());
                    }
                    if (!userUpdateData.getMembersToAdd().isEmpty() || !userUpdateData.getMembersToRemove().isEmpty()) {
                        userGroupManager.updateGroupMembers(userAccount2.getID(), userUpdateData.getMembersToAdd(), userUpdateData.getMembersToRemove());
                    }
                    if (userAccount2.getID().equals((Object)userUpdateData.getParentID())) {
                        throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.notsameasparent", new Object[0]));
                    }
                    if (userUpdateData.isParentIdChanged()) {
                        userGroupManager.setParentGroup(userAccount2.getID(), userUpdateData.getParentID());
                    }
                }
            }
            return new SaveUserOrGroupResponseData(hash);
        }
        catch (FieldValidationException fieldValidationException) {
            throw new ClientMessageException(fieldValidationException.getMessage());
        }
    }

    private Set<Permission> a(UserGroupManager userGroupManager, UserAccount userAccount) {
        HashSet<Permission> hashSet = new HashSet<Permission>(userAccount.getPermissions());
        Set set = userGroupManager.getGroupsForUser(userAccount.getID());
        Set set2 = set.stream().map(UserGroupInfo::getID).collect(Collectors.toSet());
        for (GUID gUID : set2) {
            UserGroupInfo userGroupInfo = userGroupManager.getGroup(gUID);
            if (userGroupInfo.getType() == UsersAndGroups.GROUPTYPE_ADMIN) {
                hashSet.addAll(Arrays.asList(Permission.values()));
                break;
            }
            if (!userGroupInfo.isActive()) continue;
            hashSet.addAll(userGroupInfo.getPermissions());
        }
        return hashSet;
    }

    private Set<Permission> a(UserGroupManager userGroupManager, UserAccount userAccount, GUID ... gUIDArray) {
        HashSet<Permission> hashSet = new HashSet<Permission>(userAccount.getPermissions());
        Set set = userGroupManager.getGroupsForUser(userAccount.getID());
        Set set2 = set.stream().map(UserGroupInfo::getID).collect(Collectors.toSet());
        for (GUID gUID : gUIDArray) {
            set2.remove(gUID);
        }
        for (GUID gUID : set2) {
            UserGroupInfo userGroupInfo = userGroupManager.getGroup(gUID);
            if (userGroupInfo.getType() == UsersAndGroups.GROUPTYPE_ADMIN) {
                hashSet.addAll(Arrays.asList(Permission.values()));
                break;
            }
            if (!userGroupInfo.isActive()) continue;
            hashSet.addAll(userGroupInfo.getPermissions());
        }
        return hashSet;
    }

    private SaveUserOrGroupResponseData a(UserGroupManager userGroupManager, UserAccount userAccount, UserGroupUpdateData userGroupUpdateData, UserGroupInfo userGroupInfo) {
        Set<Permission> set = this.a(userGroupManager, userAccount);
        if (this.a(set, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
            Set<Permission> set2 = this.a(userGroupManager, userAccount, userGroupInfo.getID());
            HashSet hashSet = new HashSet(userGroupInfo.getMemberIDs());
            hashSet.removeAll(userGroupUpdateData.getMembersToRemove().keySet());
            hashSet.addAll(userGroupUpdateData.getMembersToAdd().keySet());
            if (hashSet.contains(userAccount.getID())) {
                HashSet hashSet2 = new HashSet(userGroupInfo.getPermissions());
                hashSet2.removeAll(userGroupUpdateData.getRemovedPermissions());
                hashSet2.addAll(userGroupUpdateData.getAddedPermissions());
                set2.addAll(hashSet2);
            }
            if (!this.a(set2, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
                return new SaveUserOrGroupResponseData(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.save.currentuser.permissionlost.msg", new Object[0]));
            }
        }
        return null;
    }

    private SaveUserOrGroupResponseData a(UserGroupManager userGroupManager, UserAccount userAccount, UserUpdateData userUpdateData) {
        Set<Permission> set = this.a(userGroupManager, userAccount);
        if (this.a(set, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
            Set set2 = userUpdateData.getGroupsToRemoveUserFrom().keySet();
            Set<Permission> set3 = this.a(userGroupManager, userAccount, set2.toArray(new GUID[set2.size()]));
            set3.removeAll(userUpdateData.getRemovedPermissions());
            set3.addAll(userUpdateData.getAddedPermissions());
            Set set4 = userGroupManager.getGroupsForUser(userAccount.getID());
            Set set5 = set4.stream().map(UserGroupInfo::getID).collect(Collectors.toSet());
            set5.removeAll(userUpdateData.getGroupsToRemoveUserFrom().keySet());
            set5.addAll(userUpdateData.getGroupsToAddUserTo().keySet());
            boolean bl = false;
            for (GUID gUID : set5) {
                UserGroupInfo userGroupInfo = userGroupManager.getGroup(gUID);
                if (userGroupInfo.getType() == UsersAndGroups.GROUPTYPE_ADMIN) {
                    bl = true;
                }
                if (!userGroupInfo.isActive()) continue;
                set3.addAll(userGroupInfo.getPermissions());
            }
            if (!bl && !this.a(set3, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
                return new SaveUserOrGroupResponseData(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.save.currentuser.permissionlost.msg", new Object[0]));
            }
        }
        return null;
    }

    private SaveUserOrGroupResponseData b(UserGroupManager userGroupManager, @Nullable UserAccount userAccount, UserGroupUpdateData userGroupUpdateData, UserGroupInfo userGroupInfo) {
        HashSet<Permission> hashSet;
        Set<Permission> set = hashSet = userAccount == null ? new HashSet<Permission>() : this.a(userGroupManager, userAccount, userGroupInfo.getID());
        if (userGroupInfo != null && userGroupInfo.getType() == UsersAndGroups.GROUPTYPE_ADMIN) {
            hashSet.addAll(Arrays.asList(Permission.values()));
        }
        HashSet hashSet2 = new HashSet();
        if (userGroupInfo != null) {
            hashSet2.addAll(userGroupInfo.getPermissions());
        }
        hashSet2.removeAll(userGroupUpdateData.getRemovedPermissions());
        hashSet2.addAll(userGroupUpdateData.getAddedPermissions());
        hashSet.addAll(hashSet2);
        if (this.b(hashSet, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN) || this.a(hashSet, Permission.valueOfExistingOrCreate((String)"configuration"))) {
            return new SaveUserOrGroupResponseData(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.save.guestuser.permissionaccess.msg", new Object[0]));
        }
        if (this.b(hashSet, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS)) {
            return new SaveUserOrGroupResponseData(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.save.guestuser.permissionaccess.medium.msg", new Object[0]));
        }
        return null;
    }

    private SaveUserOrGroupResponseData b(UserGroupManager userGroupManager, UserAccount userAccount, UserUpdateData userUpdateData) {
        HashSet<Permission> hashSet = new HashSet<Permission>(userAccount.getPermissions());
        hashSet.removeAll(userUpdateData.getRemovedPermissions());
        hashSet.addAll(userUpdateData.getAddedPermissions());
        Set set = userGroupManager.getGroupsForUser(userAccount.getID());
        Set set2 = set.stream().map(UserGroupInfo::getID).collect(Collectors.toSet());
        set2.removeAll(userUpdateData.getGroupsToRemoveUserFrom().keySet());
        set2.addAll(userUpdateData.getGroupsToAddUserTo().keySet());
        if (this.b(hashSet, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN) || this.a(hashSet, Permission.valueOfExistingOrCreate((String)"configuration"))) {
            return new SaveUserOrGroupResponseData(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.save.guestuser.permissionaccess.msg", new Object[0]));
        }
        if (this.b(hashSet, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS)) {
            return new SaveUserOrGroupResponseData(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.save.guestuser.permissionaccess.medium.msg", new Object[0]));
        }
        for (GUID gUID : set2) {
            UserGroupInfo userGroupInfo = userGroupManager.getGroup(gUID);
            if (!userGroupInfo.isActive()) continue;
            if (userGroupInfo.getType() == UsersAndGroups.GROUPTYPE_ADMIN) {
                return new SaveUserOrGroupResponseData(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.save.guestuser.permissionaccess.msg", new Object[0]));
            }
            if (this.b(userGroupInfo.getPermissions(), UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN) || this.a(userGroupInfo.getPermissions(), Permission.valueOfExistingOrCreate((String)"configuration"))) {
                return new SaveUserOrGroupResponseData(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.save.guestuser.permissionaccess.msg", new Object[0]));
            }
            if (!this.b(userGroupInfo.getPermissions(), UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS)) continue;
            return new SaveUserOrGroupResponseData(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.save.guestuser.permissionaccess.medium.msg", new Object[0]));
        }
        return null;
    }

    private boolean a(Set<Permission> set, Permission ... permissionArray) {
        for (Permission permission : permissionArray) {
            if (!set.contains(permission)) continue;
            return true;
        }
        return false;
    }

    private boolean b(Set<Permission> set, Permission ... permissionArray) {
        for (Permission permission : permissionArray) {
            if (set.contains(permission)) continue;
            return false;
        }
        return true;
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (SaveUserOrGroupRequestData)object);
    }
}

