/*
 * Decompiled with CFR 0.152.
 */
package com.inet.translations.server.model;

import com.inet.annotations.JsonData;
import com.inet.classloader.translations.TranslationKey;
import com.inet.translations.server.model.SingleTranslationUpdate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@JsonData
public class SaveTranslationsRequest {
    private String pluginId;
    private String language;
    private Map<String, List<SingleTranslationUpdate>> translations;

    protected SaveTranslationsRequest() {
    }

    public List<TranslationKey> getTranslationKeys() {
        return this.translations.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(translation -> new TranslationKey(this.pluginId, (String)entry.getKey(), this.language, translation.getKey()))).collect(Collectors.toList());
    }

    public String getValue(TranslationKey key) {
        Optional<SingleTranslationUpdate> optional = this.translations.getOrDefault(key.bundleName, Collections.emptyList()).stream().filter(translation -> translation.getKey().equals(key.key)).findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        return optional.get().getCustomTranslation();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getLanguage() {
        return this.language;
    }
}

