/*
 * Decompiled with CFR 0.152.
 */
package com.inet.translations.server.model;

import com.inet.annotations.JsonData;
import com.inet.classloader.translations.TranslationKey;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.translations.TranslationsServerPlugin;
import com.inet.translations.server.model.internal.BundleObject;
import com.inet.translations.server.provider.a;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

@JsonData
public class GetTranslationRequest
implements Iterable<TranslationKey> {
    private String provider;
    private String pluginId;
    private String language;
    private List<BundleObject> requestedKeys;

    public String getPluginId() {
        return this.pluginId;
    }

    public String getLanguage() {
        return this.language;
    }

    public a getProvider() {
        try {
            return (a)ServerPluginManager.getInstance().getSingleInstanceByName(a.class, this.provider, false);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ClientMessageException(TranslationsServerPlugin.MSG.getMsg("translations.externalProvider.unknown", new Object[0]));
        }
    }

    private GetTranslationRequest() {
    }

    @Override
    public Iterator<TranslationKey> iterator() {
        return new Iterator<TranslationKey>(){
            private int l = 0;
            private int m = 0;

            @Override
            public boolean hasNext() {
                if (this.l < GetTranslationRequest.this.requestedKeys.size() - 1) {
                    return true;
                }
                if (this.l >= GetTranslationRequest.this.requestedKeys.size()) {
                    return false;
                }
                return this.m < GetTranslationRequest.this.requestedKeys.get(this.l).getTranslationKeys().size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public TranslationKey k() {
                BundleObject bundleObject = GetTranslationRequest.this.requestedKeys.get(this.l);
                try {
                    String string = bundleObject.getTranslationKeys().get(this.m++);
                    TranslationKey translationKey = new TranslationKey(GetTranslationRequest.this.pluginId, bundleObject.getBundleName(), GetTranslationRequest.this.language, string);
                    return translationKey;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    TranslationKey translationKey = null;
                    return translationKey;
                }
                finally {
                    if (this.m >= bundleObject.getTranslationKeys().size()) {
                        ++this.l;
                        this.m = 0;
                    }
                }
            }

            @Override
            @Nullable
            public /* synthetic */ Object next() {
                return this.k();
            }
        };
    }
}

