/*
 * Decompiled with CFR 0.152.
 */
package com.inet.translations.backup;

import com.inet.classloader.LoaderUtils;
import com.inet.classloader.translations.ResourceTools;
import com.inet.lib.util.IOFunctions;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import com.inet.translations.TranslationsServerPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class a
implements BackupTask {
    public String getKey() {
        return "translations";
    }

    public String getTitle() {
        return TranslationsServerPlugin.MSG.getMsg("translations.backup.title", new Object[0]);
    }

    public String getDescription() {
        return TranslationsServerPlugin.MSG.getMsg("translations.backup.description", new Object[0]);
    }

    public URL getIconURL() {
        return TranslationsServerPlugin.class.getResource("/com/inet/translations/resources/img/translations_32.png");
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only well known directories are used here for writing information.")
    public void execute(Path taskPath, BackupRunningStatus runningStatus, BackupContentInformation contentInformation, ProgressUpdater progressUpdater) throws Throwable {
        Set set = LoaderUtils.getLoadedBundles().keySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        progressUpdater.updateProgress(0);
        int n = 0;
        int n2 = set.size();
        for (String string : set) {
            File file = ResourceTools.getResourceZip((String)string);
            if (file.exists()) {
                IOFunctions.copy((File)file, (File)new File(taskPath.toFile(), file.getName()));
                arrayList.add(string);
            }
            progressUpdater.updateProgress(100 / n2 * n++);
        }
        if (!arrayList.isEmpty()) {
            contentInformation.addTaskDetails(this.getKey(), TranslationsServerPlugin.MSG.getMsg("translations.backup.taskdetail", new Object[]{arrayList.size()}));
            contentInformation.addTaskDetails(this.getKey(), String.join((CharSequence)", ", arrayList));
        }
        progressUpdater.updateProgress(100);
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        List<File> list = Arrays.asList(taskPath.toFile().listFiles());
        progressUpdater.updateProgress(0);
        int n = 0;
        int n2 = list.size();
        for (File file : list) {
            String string = ResourceTools.getPluginIdFromTranslationsFile((File)file);
            if (string != null) {
                for (int i = 0; i < 5; ++i) {
                    try {
                        LoaderUtils.clearTranslationCache((String)string);
                        IOFunctions.copy((File)file, (File)ResourceTools.getResourceZip((String)string));
                        break;
                    }
                    catch (IOException iOException) {
                        if (i != 4) continue;
                        throw iOException;
                    }
                }
            }
            progressUpdater.updateProgress(100 / n2 * n++);
        }
        progressUpdater.updateProgress(100);
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("20.4")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

