/*
 * Decompiled with CFR 0.152.
 */
package com.inet.translations.server.model;

import com.inet.annotations.JsonData;
import com.inet.classloader.translations.TranslationKey;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebsocketConnection;
import com.inet.translations.server.model.internal.ValidationEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonData
public class TranslationValidationResponse {
    private Map<String, List<ValidationEntry>> validationMessages = new HashMap<String, List<ValidationEntry>>();

    public void addValidationMessage(TranslationKey translationKey, String customTranslation, String validationMessage) {
        this.validationMessages.computeIfAbsent(translationKey.bundleName, k -> new ArrayList()).add(new ValidationEntry(translationKey.key, customTranslation, validationMessage));
    }

    public void sendValidationMessagesToClient(WebsocketConnection websocketConnection) {
        if (this.validationMessages.isEmpty()) {
            return;
        }
        TranslationValidationResponse translationValidationResponse = this;
        WebSocketEventHandler.getInstance().sendEvent(websocketConnection.getPollingID(), () -> new WebSocketEventData("translations_translationvalidationmessages", (Object)translationValidationResponse));
    }

    public boolean hasMessagesToSend() {
        return !this.validationMessages.isEmpty();
    }
}

