/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.plugin.setup;

import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.setupwizard.api.ReIndexTicketsListener;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.plugins.setupwizard.steps.database.HdDatabaseCheck;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessTicketData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessValueReference;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessFolder;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ConditionType;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessCondition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessProgressingConditionValue;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.usersandgroups.api.FieldValidationException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class WorkflowToProcessMigrationStep
extends AutoSetupStep {
    private GUID workflowFolder;

    public StepKey stepKey() {
        return new StepKey("workflowToProcess");
    }

    public String getStepDisplayName() {
        return TicketProcessManager.MSG.getMsg("setup.migrateWFs.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        return true;
    }

    public SetupStep.ExecutionRestriction getExecutionRestriction() {
        return SetupStep.ExecutionRestriction.ONLY_ONCE;
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        ReIndexTicketsListener.triggerReIndexOfTicketsAfterSetup();
        this.copyWFsAsProcesses();
    }

    private void copyWFsAsProcesses() throws StepExecutionException {
        DatabaseConnectionFactory f = (DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class);
        try (Connection connection = f.getConnectionFromCurrentConfiguration();){
            if (!HdDatabaseCheck.tableExists((Connection)connection, (String)"tblWorkFlows")) {
                return;
            }
            try (Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery("SELECT tblWorkFlows.WfmID IDX, WorkFlowBez, WFStep, WFBetreff, Auftext, ishtml, ItiID, BunFeld1, BunFeld2, BunFeld3, BunFeld4, spezFeld, KlaID, PriID, BetID, Schritt1, Schritt2, ResID FROM tblWorkFlowDetails INNER JOIN tblWorkFlows on tblWorkFlowDetails.WfmID = tblWorkFlows.WfmID ORDER BY tblWorkFlowDetails.WfmID, WFStep");){
                ArrayList<Row> rows = null;
                Integer currentWfId = null;
                String name = null;
                while (rs.next()) {
                    PriorityVO priorityVO;
                    String identifier;
                    String custom4;
                    String custom3;
                    String custom2;
                    String custom1;
                    String subject;
                    int wfId = rs.getInt("IDX");
                    if (currentWfId == null || currentWfId != wfId) {
                        if (currentWfId != null) {
                            this.saveWfAsProcess(name, rows);
                        }
                        currentWfId = wfId;
                        rows = new ArrayList<Row>();
                        name = rs.getString("WorkFlowBez");
                    }
                    Row row = new Row();
                    row.number = rs.getInt("WFStep");
                    row.subject = subject = rs.getString("WFBetreff");
                    row.dataToSet.putRef(Tickets.FIELD_SUBJECT, ProcessValueReference.createReferencingWithSuffix(null, (TicketField<String>)Tickets.FIELD_SUBJECT, subject));
                    String aufText = rs.getString("Auftext");
                    int html = rs.getInt("ishtml");
                    row.ticketText = ReaStepTextVO.of((String)aufText, (html == 1 ? 1 : 0) != 0);
                    int itil = rs.getInt("ItiID");
                    if (!rs.wasNull()) {
                        row.dataToSet.put(Tickets.FIELD_ITIL_ID, itil);
                    }
                    if ((custom1 = rs.getString("BunFeld1")) != null) {
                        try {
                            row.dataToSet.put(Tickets.getFieldByKey((String)"custom1"), custom1);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if ((custom2 = rs.getString("BunFeld2")) != null) {
                        try {
                            row.dataToSet.put(Tickets.getFieldByKey((String)"custom2"), custom2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if ((custom3 = rs.getString("BunFeld3")) != null) {
                        try {
                            row.dataToSet.put(Tickets.getFieldByKey((String)"custom3"), custom3);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if ((custom4 = rs.getString("BunFeld4")) != null) {
                        try {
                            row.dataToSet.put(Tickets.getFieldByKey((String)"custom4"), custom4);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if ((identifier = rs.getString("spezFeld")) != null) {
                        row.dataToSet.put(Tickets.FIELD_IDENTIFIER, identifier);
                    }
                    int classification = rs.getInt("KlaID");
                    if (!rs.wasNull()) {
                        try {
                            row.dataToSet.put(Tickets.FIELD_CLASSIFICATION_ID, classification);
                        }
                        catch (FieldValidationException fieldValidationException) {
                            // empty catch block
                        }
                    }
                    int prio = rs.getInt("PriID");
                    if (!rs.wasNull() && (priorityVO = (PriorityVO)PriorityManager.getInstance().get(prio)) != null && !priorityVO.isDeleted()) {
                        row.dataToSet.put(Tickets.FIELD_PRIORITY_ID, prio);
                    }
                    int category = rs.getInt("BetID");
                    if (!rs.wasNull() && category != 0) {
                        row.dataToSet.put(Tickets.FIELD_CATEGORY_ID, category);
                    }
                    row.afterStep1 = rs.getInt("Schritt1");
                    row.afterStep2 = rs.getInt("Schritt2");
                    row.dataToSet.put(Tickets.FIELD_RESOURCE_GUID, HDUsersAndGroups.getResourceGroupUUID((int)rs.getInt("ResID")));
                    rows.add(row);
                }
                if (currentWfId != null) {
                    this.saveWfAsProcess(name, rows);
                }
            }
        }
        catch (ClassNotFoundException | SQLException throwables) {
            throw new StepExecutionException((Throwable)throwables);
        }
    }

    void saveWfAsProcess(String name, List<Row> rows) {
        SetupLogger.LOGGER.info((Object)("[Process] Convert workflow " + name + " to a process."));
        TicketProcessManager tpm = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        if (this.workflowFolder == null) {
            String folderName = "Workflows (migriert)";
            Optional<TicketProcessFolder> findFirst = tpm.getRootFolder().getSubFolders().stream().filter(f -> f.getName().equals(folderName)).findFirst();
            this.workflowFolder = findFirst.isPresent() ? findFirst.get().getId() : tpm.createFolder(null, folderName);
        }
        List<Integer> actions = TicketProcessManager.getDefaultAllowedActions().stream().map(FieldVO::getId).collect(Collectors.toList());
        ArrayList<Integer> actionsWithBeenden = new ArrayList<Integer>(actions);
        actionsWithBeenden.add(2);
        try {
            ArrayList<ParallelTicket> tickets = new ArrayList<ParallelTicket>(rows.size());
            for (Row row : rows) {
                Activity activity = new Activity(GUID.generateNew(), Collections.emptyList(), row.subject, "", actionsWithBeenden, row.dataToSet, row.ticketText, false);
                ArrayList conditions = new ArrayList();
                if (row.afterStep1 != 0) {
                    conditions.add(new ProcessCondition<ProcessProgressingConditionValue>(new ProcessProgressingConditionValue(this.idOfParallelTicketWithNumber(row.afterStep1, rows), false), ConditionType.TICKET_FINISHED));
                }
                if (row.afterStep2 != 0) {
                    conditions.add(new ProcessCondition<ProcessProgressingConditionValue>(new ProcessProgressingConditionValue(this.idOfParallelTicketWithNumber(row.afterStep2, rows), false), ConditionType.TICKET_FINISHED));
                }
                ParallelTicket pt = new ParallelTicket(row.ID, row.subject, Collections.singletonList(activity), activity.getId(), conditions, false, null);
                tickets.add(pt);
            }
            GUID main1 = GUID.generateNew();
            GUID main2 = GUID.generateNew();
            ArrayList<Activity> activities = new ArrayList<Activity>();
            List<ActivityTransition> transitions = Arrays.asList(new ActivityTransition(main2, "Beenden, da Teilschritte abgeschlossen", 2, Collections.singletonList(new ProcessCondition<Void>(null, ConditionType.ALL_TICKETS_FINISHED)), null), new ActivityTransition(main2, "Beenden", 2));
            activities.add(new Activity(main1, null, Activity.Type.Standard, Collections.emptyList(), transitions, name, "", actions, new ProcessTicketData()));
            activities.add(new Activity(main2, null, Activity.Type.Standard, Collections.emptyList(), Collections.emptyList(), "Teilschritte abgeschlossen", "", actionsWithBeenden, new ProcessTicketData()));
            TicketProcess process = new TicketProcess(GUID.generateNew(), name, "Dieser Prozess wurde aus dem gleichnamigen Workflow erzeugt", activities, main1, tickets, TicketProcess.AdditionalResourceAccess.READ, true);
            tpm.createProcess(process, this.workflowFolder);
        }
        catch (Exception ex) {
            SetupLogger.LOGGER.warn((Object)"[Process] Could not convert workflow to process.");
            SetupLogger.LOGGER.warn((Object)ex);
        }
    }

    private GUID idOfParallelTicketWithNumber(int number, List<Row> rows) {
        for (Row row : rows) {
            if (row.number != number) continue;
            return row.ID;
        }
        throw new IllegalStateException("No step exists with number " + number);
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5980);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> this.getStepDisplayName();
    }

    class Row {
        private GUID ID = GUID.generateNew();
        private ProcessTicketData dataToSet = new ProcessTicketData();
        ReaStepTextVO ticketText;
        String subject;
        int number;
        private int afterStep1;
        private int afterStep2;

        Row() {
        }
    }
}

