/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.plugin.setup;

import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.DBUpdateBackdoor;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.utils.DatabaseVersionChecker;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.plugins.setupwizard.steps.database.HdDatabaseCheck;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessTicketData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessFolder;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ConditionType;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessCondition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessProgressingConditionValue;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressInfo;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.utils.Version;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UpdateProcessDatabaseStep
extends AutoSetupStep {
    public StepKey stepKey() {
        return new StepKey("TicketProcessDatabase");
    }

    public String getStepDisplayName() {
        return TicketProcessManager.MSG.getMsg("setup.updatedatabase.displayname", new Object[0]);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> TicketProcessManager.MSG.getMsg("setup.updatedatabase.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        boolean databaseStructureChanged = new DatabaseVersionChecker().isDatabaseStructureChanged(TicketProcessPlugin.class);
        if (databaseStructureChanged) {
            return true;
        }
        String dbConfigs = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS.getKey());
        if (dbConfigs == null || dbConfigs.isEmpty()) {
            return true;
        }
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class);
        DatabaseConfigInfo dbInfo = list.get("HDS");
        if (dbInfo == null) {
            return true;
        }
        try {
            if (HdDatabaseCheck.tableExists((DatabaseConnectionFactory)((DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class)), (String)"tblTicketProcesses")) {
                return false;
            }
        }
        catch (SQLException t) {
            SetupLogger.LOGGER.debug((Object)t);
            return true;
        }
        catch (Throwable e) {
            SetupLogger.LOGGER.error(e);
            return true;
        }
        return true;
    }

    public void execute(EmptyStepConfig stepConfig, Map metaData) throws StepExecutionException {
        String dbConfigs = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS.getKey());
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class);
        DatabaseConfigInfo dbInfo = list.get("HDS");
        try {
            DBUpdateBackdoor dbUpdater = (DBUpdateBackdoor)ServerPluginManager.getInstance().getSingleInstance(DBUpdateBackdoor.class);
            dbUpdater.updateDB(dbInfo, TicketProcessPlugin.class, null, null, event -> this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(5, () -> event.getCurrentJobName(ClientLocale.getThreadLocale()))));
            new DatabaseVersionChecker().markDatabaseStructureChanged(TicketProcessPlugin.class);
        }
        catch (Throwable t) {
            throw new StepExecutionException(t);
        }
        Version lastMigratedVersionOfThisPlugin = this.getLastMigratedVersionOfThisPlugin();
        if (lastMigratedVersionOfThisPlugin == null) {
            this.createSampleProcesses();
        }
    }

    private void createSampleProcesses() {
        GUID folderId;
        boolean RESOURCE_NETZADMINISTRATOR_ID = true;
        int RESOURCE_FIRST_LEVEL_SUPPORT_ID = 2;
        int RESOURCE_SECOND_LEVEL_SUPPORT_ID = 3;
        try {
            this.res(3);
            this.res(2);
            this.res(1);
        }
        catch (Exception ex) {
            SetupLogger.LOGGER.warn((Object)("Cannot create samples because resource seems to be missing: " + ex.getMessage()));
            return;
        }
        TicketProcessManager manager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        String folderName = "Beispiele";
        try {
            folderId = manager.createFolder(null, folderName);
        }
        catch (RuntimeException ex) {
            Optional<TicketProcessFolder> folder = manager.getRootFolder().getSubFolders().stream().filter(f -> f.getName().equals(folderName)).findFirst();
            if (folder.isPresent()) {
                folderId = folder.get().getId();
            }
            SetupLogger.LOGGER.warn((Object)("Cannot create sample folder: " + ex.getMessage()));
            return;
        }
        final GUID aufnehmen = GUID.generateNew();
        final GUID freigabe = GUID.generateNew();
        final GUID userInfo = GUID.generateNew();
        final GUID technKl = GUID.generateNew();
        final GUID ausloesen = GUID.generateNew();
        final GUID warenannahme = GUID.generateNew();
        final GUID finish = GUID.generateNew();
        ArrayList<Activity> asList = new ArrayList<Activity>(){
            {
                List<ActivityTransition> followActs = Collections.singletonList(new ActivityTransition(freigabe, "Weiter zum Freigabe pr\u00fcfen", 1));
                List<Integer> actions = Arrays.asList(1, 10, 9, -3, -7, -15, 3, -26, -27, -29, 5);
                String descr = "Der First Level Support soll in diesem Prozess-Schritt eine Bestellung aufnehmen und auf Vollst\u00e4ndigkeit pr\u00fcfen. Alle normalen Aktionen sind zugelassen mit Ausnahme, das Ticket zu beenden.";
                ProcessTicketData incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(2));
                this.add(new Activity(aufnehmen, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Bestellung aufnehmen", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(userInfo, "Bestellung ablehnen", -36), new ActivityTransition(technKl, "Bestellung akzeptieren", -36));
                actions = Arrays.asList(-7);
                descr = "Nun soll der Second Level die Freigabe der Bestellung pr\u00fcfen, zum Beispiel per E-Mail an den IT-Leiter. Andere Aktionen sind hier nicht zugelassen. Bei einer Zustimmung geht es weiter mit \"Technische Kl\u00e4rung\" durch den Netzadministrator, bei einer Ablehnung weiter mit \"User informieren und Ticket beenden\" durch den First Level.";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(3));
                this.add(new Activity(freigabe, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Freigabe pr\u00fcfen", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(finish, "Prozess erledigt", 2));
                actions = Arrays.asList(-7);
                descr = "Hier soll der First Level Support den User \u00fcber die Ablehnung seiner Bestellung informieren, z.B. per E-Mail, und anschlie\u00dfend das Ticket und somit den Prozess beenden.";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(2));
                this.add(new Activity(userInfo, null, Activity.Type.Standard, Collections.emptyList(), followActs, "User informieren und Ticket beenden", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(ausloesen, "Technische Pr\u00fcfung erledigt", -36));
                actions = Arrays.asList(1, 10, 9, -3, -7, -15, 3, -17);
                descr = "Hier soll der Netzadministrator eventuelle technische Fragen kl\u00e4ren. Er kann alle Aktionen ausf\u00fchren, aber das Ticket nicht beenden. ";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(1));
                this.add(new Activity(technKl, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Technische Kl\u00e4rung", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(warenannahme, "Bestellung ausgel\u00f6st", -36));
                actions = Arrays.asList(1, 10, 9, -3, -7, -15, 3, -17);
                descr = "Der First Level Support l\u00f6st hier die Bestellung aus und leitet an den letzten Prozesschritt durch den Netzadministrator weiter.";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(2));
                this.add(new Activity(ausloesen, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Bestellung ausl\u00f6sen", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(finish, "Bestellung abgeschlossen", 2));
                actions = Arrays.asList(1, 10, 9, -3, -7, -15, 3, -17);
                descr = "Der Netzadministrator nimmt die Ware an, liefert sie aus und kann hiernach das Ticket (und somit den durchlaufenen Prozess) beenden.";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(1));
                this.add(new Activity(warenannahme, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Warenannahme und Auslieferung", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition[0]);
                actions = Arrays.asList(new Integer[0]);
                descr = "Dies entfernt den Prozess vom Ticket";
                incomingTicketData = new ProcessTicketData();
                this.add(new Activity(finish, null, Activity.Type.FinishProcess, Collections.emptyList(), followActs, "Prozess beenden", descr, actions, incomingTicketData));
            }
        };
        this.addProcessToManager(manager, folderId, (List<Activity>)asList, aufnehmen, "Beispiel: Bestellung aufnehmen", "Aufnahme und Bearbeitung einer Bestellung \u00fcber mehrere Ressourcen.", new ParallelTicket[0]);
        final GUID analyse = GUID.generateNew();
        final GUID first = GUID.generateNew();
        final GUID netz = GUID.generateNew();
        final GUID second = GUID.generateNew();
        final GUID changes = GUID.generateNew();
        asList = new ArrayList<Activity>(){
            {
                boolean CLASS_PRODUKTANPASSUNG = true;
                int CLASS_PRODUKTWEITERENTWICKLUNG = 2;
                int CLASS_PRODUKTFEHLER = 3;
                List<ActivityTransition> followActs = Arrays.asList(new ActivityTransition(first, "Fehler - direkt beheben", 5), new ActivityTransition(netz, "Weiterentwicklung - einplanen", 5), new ActivityTransition(second, "Anpassung - Workaround ermitteln ", 5));
                List<Integer> actions = Arrays.asList(-7, -6, -21, -10, -31, -17, -22, -15, -26, -27, -28, 3, -30, -29, -35);
                String descr = "Der Dispatcher pr\u00fcft, um was genau es sich handelt und wer f\u00fcr hierf\u00fcr zust\u00e4ndig ist. Er kann mit dem Kunden per Mail R\u00fccksprache halten, sonst keine Aktionen ausf\u00fchren au\u00dfer das Ticket an den Verantwortlichen zu autorisieren. Dieser Prozess kann nur auf Anfragen angewendet werden.";
                ProcessTicketData incomingTicketData = new ProcessTicketData();
                this.add(new Activity(analyse, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Zust\u00e4ndigkeit pr\u00fcfen", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(changes, "Fehler behoben", -36));
                actions = Arrays.asList(1, 10, 9, -3, -7, -6, -21, -10, -31, -17, -22, -15, -26, -27, -28, 3, -30, -29, -35);
                descr = "Direkt Fehler im First level beheben. Die Klassifizierung wird automatisch gesetzt";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(2));
                incomingTicketData.put(Tickets.FIELD_CLASSIFICATION_ID, 3);
                this.add(new Activity(first, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Fehlerbehebung", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(changes, "Funktion eingeplant", -36));
                descr = "Weiterentwicklung soll eingeplant werden. Die Klassifizierung wird automatisch gesetzt";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(1));
                incomingTicketData.put(Tickets.FIELD_CLASSIFICATION_ID, 2);
                this.add(new Activity(netz, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Planung Weiterentwicklung", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(changes, "Anpassung vorgenommen", -36));
                descr = "Anpassung soll vorgenommen werden. Die Klassifizierung wird automatisch gesetzt";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(3));
                incomingTicketData.put(Tickets.FIELD_CLASSIFICATION_ID, 1);
                this.add(new Activity(second, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Anpassung vornehmen", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(finish, "Vorgang beenden", 2));
                descr = "Die Ressource, die auch vorher verantworlich war, muss jetzt die gemachten \u00c4nderungen protokollieren, bevor das Ticket beendet wird.";
                incomingTicketData = new ProcessTicketData();
                this.add(new Activity(changes, null, Activity.Type.Standard, Collections.emptyList(), followActs, "\u00c4nderungen protokollieren", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition[0]);
                actions = Arrays.asList(new Integer[0]);
                descr = "Dies entfernt den Prozess vom Ticket";
                incomingTicketData = new ProcessTicketData();
                this.add(new Activity(finish, null, Activity.Type.FinishProcess, Collections.emptyList(), followActs, "Prozess beenden", descr, actions, incomingTicketData));
            }
        };
        this.addProcessToManager(manager, folderId, (List<Activity>)asList, analyse, "Beispiel: Zuweisungssteuerung (nur f\u00fcr Anfragen)", "Dieser Prozess ermittelt, wer f\u00fcr das Ticket verantwortlich ist und setzt automatisch die entsprechende Klassifizierung. Er kann nicht auf autorisierte Tickets angewendet werden, weil ausschlie\u00dflich 'Autorisieren' zum Voranschreiten in der ersten Aktivit\u00e4t konfiguriert ist.", new ParallelTicket[0]);
        final GUID dispatcher = GUID.generateNew();
        final GUID analysing = GUID.generateNew();
        final GUID umsetzung = GUID.generateNew();
        final GUID waiting = GUID.generateNew();
        final GUID testing = GUID.generateNew();
        final GUID closed = GUID.generateNew();
        final GUID feedback = GUID.generateNew();
        final GUID parallelTicketGuid = GUID.generateNew();
        asList = new ArrayList<Activity>(){
            {
                List<ActivityTransition> followActs = Arrays.asList(new ActivityTransition(analysing, "Analyse starten", 1));
                List<Integer> actions = Arrays.asList(5, -7, -12, -6, -21, -10, -31, -17, -22, -15, -26, -27, -28, 3, -30, -29, -35);
                String descr = "Erster Schritt ist die Autorisierung. Wenn das Ticket noch nicht autorisiert ist, kann der Verantwortliche hier die Anfrage autorisieren. Die Weiterschaltung erfolgt dann im Anschluss. Falls das Ticket bereits autorisiert ist kann direkt weitergeschaltet werden.";
                ProcessTicketData incomingTicketData = new ProcessTicketData();
                this.add(new Activity(dispatcher, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Dispatching", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(umsetzung, "Weiter zur Umsetzung", 8));
                actions = Arrays.asList(1, 10, 9, -3, -7, -12, -6, -21, -10, -31, -17, -22, -15, -26, -27, -28, 3, -30, -29, -35);
                descr = "Analyse des Problems mit m\u00f6glicher Kundenr\u00fccksprache.";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(2));
                this.add(new Activity(analysing, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Analyse", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(waiting, "Umsetzung erledigt", -3));
                descr = "\u00c4nderungen umsetzen.";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(1));
                this.add(new Activity(umsetzung, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Umsetzung", descr, actions, incomingTicketData));
                List<ProcessCondition<?>> autoCondition = Collections.singletonList(new ProcessCondition<ProcessProgressingConditionValue>(new ProcessProgressingConditionValue(parallelTicketGuid, false), ConditionType.TICKET_FINISHED));
                followActs = Arrays.asList(new ActivityTransition(testing, "Zum Testen \u00fcbergeben", -36, autoCondition, null));
                descr = "Hier ist nichts zu tun. Das Ticket wird auf Wiedervorlage gesetzt, damit es ausgeblendet wird. Es wird automatisch weitergeschaltet, wenn alle Teile der Umsetzung fertig sind.";
                incomingTicketData = new ProcessTicketData();
                this.add(new Activity(waiting, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Warte auf Fertigstellung", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(closed, "Test bestanden", 2), new ActivityTransition(umsetzung, "Test nicht bestanden", 8));
                descr = "\u00c4nderungen nachtesten. Je nachdem ob die Tests erfolgreich sind, wird das Ticket beendet oder geht zur\u00fcck zum vorherigen Schritt.";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(2));
                this.add(new Activity(testing, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Testing", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(feedback, "Feedback geben", -12));
                actions = Arrays.asList(new Integer[0]);
                descr = "Das Ticket ist beendet, der Prozess bleibt aber aktiv. Den einzigen Wechsel kann der Kunde durch einen Kommentar vollziehen, woraufhin dieses Feedback nochmal evaluiert wird.";
                incomingTicketData = new ProcessTicketData();
                this.add(new Activity(closed, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Erledigt", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(closed, "Alles in Ordnung", 2), new ActivityTransition(analysing, "Meldet: funktioniert nicht, nochmal analysieren", -36));
                actions = Arrays.asList(-12);
                descr = "Pr\u00fcfung ob laut Kundenfeedback das Problem behoben ist. Je nachdem dann das Ticket beenden, sonst nochmal zur\u00fcck zum Analysieren.";
                incomingTicketData = new ProcessTicketData();
                this.add(new Activity(feedback, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Reaktion vom Kunden", descr, actions, incomingTicketData));
            }
        };
        ArrayList parallelActivities = new ArrayList<Activity>(){
            {
                List<Integer> actions = Arrays.asList(1, 2, 10, 9, -3, -7, -12, -6, -21, -10, -31, -17, -22, -15, -26, -27, -28, 3, -30, -29, -35);
                String descr = "Umsetzung auf der Website vornehmen.";
                ProcessTicketData incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(3));
                incomingTicketData.put(Tickets.FIELD_SUBJECT, "Website-Anpassung");
                this.add(new Activity(GUID.generateNew(), Collections.emptyList(), "Unterst\u00fctzung Website", descr, actions, incomingTicketData, ReaStepTextVO.empty(), false));
            }
        };
        List<ProcessCondition<Object>> conditions = Collections.singletonList(new ProcessCondition<ProcessProgressingConditionValue>(new ProcessProgressingConditionValue(umsetzung, false), ConditionType.ACTIVITY_VISITED));
        ParallelTicket p1 = new ParallelTicket(parallelTicketGuid, "Externe Unterst\u00fctzung", parallelActivities, ((Activity)parallelActivities.get(0)).getId(), conditions, false, null);
        this.addProcessToManager(manager, folderId, (List<Activity>)asList, dispatcher, "Beispiel: Komplett-Ablauf", "Dieser Prozess steuert den kompletten Ablauf vom Autorisieren \u00fcber die Verarbeitung und Beendigung bis zum m\u00f6glichen Reaktivieren durch den Endanwender.", p1);
        final GUID prepare = GUID.generateNew();
        final GUID progress = GUID.generateNew();
        final GUID checkup = GUID.generateNew();
        final GUID done = GUID.generateNew();
        final ProcessTicketData incomingTicketData = new ProcessTicketData();
        final List<Integer> actions = Arrays.asList(5, 1, -3, 9, 10, -7, -12, -6, -21, -10, -31, -17, -22, -15, -26, -27, -28, 3, -30, -29, -35);
        asList = new ArrayList<Activity>(){
            {
                List<ActivityTransition> followActs = Arrays.asList(new ActivityTransition(progress, "Bearbeitung starten", 1));
                String descr = "Zur Vorbereitung muss die Deadline bestimmt werden: Die Foleaktivit\u00e4t erfordert das Feld Deadline.";
                this.add(new Activity(prepare, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Vorgang vorbereiten", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(checkup, "Bearbeitung erledigt", 1));
                descr = "Die Bearbeitung macht den Gro\u00dfteil des Aufwandes aus.";
                List<String> requiredFieldKeys = Collections.singletonList(Tickets.FIELD_DEADLINE.getKey());
                this.add(new Activity(progress, null, Activity.Type.Standard, requiredFieldKeys, followActs, "Vorgang bearbeiten", descr, actions, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(done, "Beenden", 2));
                descr = "Nach der Bearbeitung muss noch ein kleiner Check-up durchgef\u00fchrt werden, sp\u00e4testens hier m\u00fcssen Klassifizierung und Kategorie festgelegt werden.";
                this.add(new Activity(checkup, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Check-Up", descr, actions, incomingTicketData));
                List<Integer> actions2 = Arrays.asList(new Integer[0]);
                List<String> requiredFieldKeys2 = Arrays.asList(Tickets.FIELD_CLASSIFICATION_ID.getKey(), Tickets.FIELD_CATEGORY_ID.getKey());
                String descr2 = "In dieser Aktivit\u00e4t ist das Ticket beendet, weil der \u00dcbergang mit der Aktion 'Beenden' ausgef\u00fchrt wird. Diese Aktivit\u00e4t erlaubt keine Reaktivierung oder Kommentierung. Das Ticket bleibt im Prozess.";
                this.add(new Activity(done, null, Activity.Type.Standard, requiredFieldKeys2, Collections.emptyList(), "Erledigt", descr2, actions2, incomingTicketData));
            }
        };
        this.addProcessToManager(manager, folderId, (List<Activity>)asList, prepare, "Beispiel: Erforderliche Ticket-Felder und Reaktivierung blockieren", "Dieser Prozess fordert an unterschiedlichen Stellen, dass bestimmte Ticketfelder gesetzt wurden. Au\u00dferdem bleibt der Prozess beim Beenden des Tickets aktiv, um eine Reaktivierung zu unterbinden.", new ParallelTicket[0]);
        final GUID M1 = GUID.generateNew();
        final GUID M2 = GUID.generateNew();
        final GUID M3 = GUID.generateNew();
        final GUID M4 = GUID.generateNew();
        final GUID M5 = GUID.generateNew();
        final GUID E1 = GUID.generateNew();
        final GUID E2 = GUID.generateNew();
        final GUID T1 = GUID.generateNew();
        final GUID U1 = GUID.generateNew();
        final GUID R1 = GUID.generateNew();
        final List<Integer> actionsMitBeenden = Arrays.asList(5, 2, 1, -7, -12, -6, -21, -10, -31, -17, -22, -15, -26, -27, -28, 3, -30, -29, -35);
        final List<Integer> actionNoBeenden = Arrays.asList(5, 1, -7, -12, -6, -21, -10, -31, -17, -22, -15, -26, -27, -28, 3, -30, -29, -35);
        asList = new ArrayList<Activity>(){
            {
                List<ActivityTransition> followActs = Arrays.asList(new ActivityTransition(M2, "Meeting geplant", 1));
                String descr = "Wer? Wann? Was?";
                ProcessTicketData incomingTicketData = new ProcessTicketData();
                this.add(new Activity(M1, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Datum, Thema und Teilnehmer bestimmen", descr, actionNoBeenden, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(M3, null, -36, Arrays.asList(new ProcessCondition<Void>(null, ConditionType.ALL_TICKETS_FINISHED)), null));
                descr = "Meeting steht im Kalender und muss organisiert werden.";
                incomingTicketData = new ProcessTicketData();
                this.add(new Activity(M2, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Meeting geplant", descr, actionNoBeenden, incomingTicketData));
                followActs = Arrays.asList(new ActivityTransition(M4, "Meeting beendet", -36));
                descr = "Alles ist organisiert und es kann losgehen!";
                incomingTicketData = new ProcessTicketData();
                this.add(new Activity(M3, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Meeting durchf\u00fchren", descr, actionNoBeenden, incomingTicketData));
                List<ProcessCondition<?>> autoCondition = Collections.singletonList(new ProcessCondition<Void>(null, ConditionType.ALL_TICKETS_FINISHED));
                followActs = Arrays.asList(new ActivityTransition(M5, "", 2, autoCondition, null));
                descr = "Meeting wurde beendet. Ergebnisse werden festgehalten.";
                incomingTicketData = new ProcessTicketData();
                this.add(new Activity(M4, null, Activity.Type.Standard, Collections.emptyList(), followActs, "Meeting durchgef\u00fchrt", descr, actionNoBeenden, incomingTicketData));
                descr = "Alles ist erledigt, nichts kann mehr ge\u00e4ndert werden.";
                incomingTicketData = new ProcessTicketData();
                this.add(new Activity(M5, null, Activity.Type.Standard, Collections.emptyList(), Collections.emptyList(), "Beendet", descr, Collections.emptyList(), incomingTicketData));
            }
        };
        parallelActivities = new ArrayList<Activity>(){
            {
                List<ActivityTransition> followActs = Arrays.asList(new ActivityTransition(E2, "", -36));
                String descr = "Meetingraum f\u00fcr Anzahl der Teilnehmer organisieren.";
                ProcessTicketData incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(1));
                incomingTicketData.put(Tickets.FIELD_SUBJECT, "Meetingraum organisieren");
                this.add(new Activity(E1, followActs, "Meetingraum organisieren", descr, actionNoBeenden, incomingTicketData, ReaStepTextVO.empty(), false));
                descr = "Catering f\u00fcr organisierten Raum bestellen.";
                incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_SUBJECT, "Catering organisieren");
                this.add(new Activity(E2, null, Activity.Type.Standard, Collections.emptyList(), Collections.emptyList(), "Catering organisieren", descr, actionsMitBeenden, incomingTicketData));
            }
        };
        conditions = Collections.singletonList(new ProcessCondition<ProcessProgressingConditionValue>(new ProcessProgressingConditionValue(M1, false), ConditionType.ACTIVITY_FINISHED));
        ParallelTicket pt1 = new ParallelTicket(GUID.generateNew(), "Externe Organisation", parallelActivities, ((Activity)parallelActivities.get(0)).getId(), conditions, false, null);
        parallelActivities = new ArrayList<Activity>(){
            {
                String descr = "Besprechungsthemen vorbereiten.";
                ProcessTicketData incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(3));
                incomingTicketData.put(Tickets.FIELD_SUBJECT, "Themen zusammenstellen");
                this.add(new Activity(T1, Collections.emptyList(), "Themen zusammenstellen", descr, actionsMitBeenden, incomingTicketData, ReaStepTextVO.empty(), false));
            }
        };
        conditions = Collections.singletonList(new ProcessCondition<ProcessProgressingConditionValue>(new ProcessProgressingConditionValue(M1, false), ConditionType.ACTIVITY_FINISHED));
        ParallelTicket pt2 = new ParallelTicket(GUID.generateNew(), "Themen", parallelActivities, ((Activity)parallelActivities.get(0)).getId(), conditions, false, null);
        parallelActivities = new ArrayList<Activity>(){
            {
                String descr = "Teilnehmer per Email einladen.";
                ProcessTicketData incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(3));
                incomingTicketData.put(Tickets.FIELD_SUBJECT, "Teilnehmer einladen");
                this.add(new Activity(U1, Collections.emptyList(), "Teilnehmer einladen", descr, actionsMitBeenden, incomingTicketData, ReaStepTextVO.empty(), false));
            }
        };
        conditions = Collections.singletonList(new ProcessCondition<ProcessProgressingConditionValue>(new ProcessProgressingConditionValue(E1, false), ConditionType.ACTIVITY_FINISHED));
        ParallelTicket pt3 = new ParallelTicket(GUID.generateNew(), "Teilnehmer", parallelActivities, ((Activity)parallelActivities.get(0)).getId(), conditions, false, null);
        parallelActivities = new ArrayList<Activity>(){
            {
                String descr = "f\u00fcr Catering und Meeting-Raum";
                ProcessTicketData incomingTicketData = new ProcessTicketData();
                incomingTicketData.put(Tickets.FIELD_RESOURCE_GUID, UpdateProcessDatabaseStep.this.res(1));
                incomingTicketData.put(Tickets.FIELD_SUBJECT, "Rechnungen begleichen");
                this.add(new Activity(R1, Collections.emptyList(), "Rechnungen begleichen", descr, actionsMitBeenden, incomingTicketData, ReaStepTextVO.empty(), false));
            }
        };
        conditions = Collections.singletonList(new ProcessCondition<ProcessProgressingConditionValue>(new ProcessProgressingConditionValue(M3, false), ConditionType.ACTIVITY_FINISHED));
        ParallelTicket pt4 = new ParallelTicket(GUID.generateNew(), "Rechnungen", parallelActivities, ((Activity)parallelActivities.get(0)).getId(), conditions, false, null);
        this.addProcessToManager(manager, folderId, (List<Activity>)asList, M1, "Beispiel: Meeting organisieren", "Organisation eines Firmen-Meetings, wo verschiedene Akteure parallel und nacheinander n\u00f6tige Aufgaben erledigen.", pt1, pt2, pt3, pt4);
    }

    private void addProcessToManager(TicketProcessManager manager, GUID folderId, List<Activity> asList, GUID initialActivity, String name, String description, ParallelTicket ... parallelTickets) {
        try {
            TicketProcess process = new TicketProcess(GUID.generateNew(), name, description, asList, initialActivity, Arrays.asList(parallelTickets), TicketProcess.AdditionalResourceAccess.NONE, false);
            manager.createProcess(process, folderId);
            SetupLogger.LOGGER.info((Object)("Added sample process \"" + process.getName() + "\""));
        }
        catch (ClientMessageException ex) {
            SetupLogger.LOGGER.warn((Object)("Cannot add sample process: " + ex.getMessage()));
        }
    }

    private GUID res(int resID) {
        return HDUsersAndGroups.getResource((int)resID).getID();
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5970);
    }
}

