/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.validation;

import com.inet.helpdesk.core.model.general.RelativeOrAbsoluteDate;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ActivityTransitionAction;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessTools;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessValidationException;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessValueReference;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ConditionType;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessCondition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessProgressingConditionValue;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.DeadPathCheck;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.TicketBranch;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.FieldValidationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ProcessAnalyser {
    static final int STATUS_UNDEFINED = -9123;
    static final int DISPATCHED_NO = 1;
    static final int DISPATCHED_YES = 2;
    static final int DISPATCHED_UNKNOWN = 3;
    Set<TicketBranch> allPaths = new HashSet<TicketBranch>();
    TicketBranch mainPath;
    TicketProcess process;
    private Set<GUID> allActivityIds = new HashSet<GUID>();

    public static void validate(TicketProcess process) {
        new ProcessAnalyser(process, 3, null);
    }

    public static void validate(TicketProcess process, boolean ticketIsDispatched) {
        new ProcessAnalyser(process, ticketIsDispatched ? 2 : 1, null);
    }

    public static void validateForTicketInStateOnly(TicketProcess process, ProcessTickets tickets) {
        GUID attribute = (GUID)tickets.getMainTicket().getAttribute(TicketProcessManager.ATTRIBUTE_ACTIVITY);
        if (attribute == null) {
            throw new IllegalArgumentException("Ticket to check has no activity");
        }
        for (TicketVO vo : tickets.allTickets()) {
            Activity activity = process.getActivity((GUID)vo.getAttribute(TicketProcessManager.ATTRIBUTE_ACTIVITY));
            if (activity == null) {
                Activity oldActivity = tickets.getProcess().getActivity((GUID)vo.getAttribute(TicketProcessManager.ATTRIBUTE_ACTIVITY));
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.update.activityDoesNotExists", new Object[]{oldActivity.getName(), vo.getID()}), process);
            }
            ParallelTicket newParent = ProcessTools.parallelTicketHoldingActivity(activity.getId(), process);
            ParallelTicket oldParent = ProcessTools.parallelTicketHoldingActivity(activity.getId(), tickets.getProcess());
            if (!Objects.equals(oldParent == null ? null : oldParent.getId(), newParent == null ? null : newParent.getId())) {
                Activity oldActivity = tickets.getProcess().getActivity((GUID)vo.getAttribute(TicketProcessManager.ATTRIBUTE_ACTIVITY));
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.update.activityDoesNotExists", new Object[]{oldActivity.getName(), vo.getID()}), process);
            }
            if (activity.getType() != Activity.Type.FinishProcess) continue;
            throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.update.activityCannotChangeToFinish", new Object[]{vo.getID()}), process, activity);
        }
        new ProcessAnalyser(process, 3, tickets);
    }

    private ProcessAnalyser(TicketProcess process, int dispatched, ProcessTickets tickets) {
        this.process = process;
        this.mainPath = new TicketBranch(this.allPaths, null, process);
        this.checkActivities(process, process.getActivities(), process.getStart(), true);
        for (ParallelTicket pt : process.getParallelTickets()) {
            if (pt.isDeactivated()) continue;
            new TicketBranch(this.allPaths, pt, process);
            this.checkActivities(process, pt.getActivities(), pt.getStart(), false);
            ReaStepTextVO ticketText = pt.getStart().getTicketText();
            if (ticketText == null) {
                throw new ProcessValidationException("Must specify non null text for parallel ticket " + pt.getName(), process, pt);
            }
            ProcessValueReference subjectValueReference = pt.getStart().getIncomingTicketData().get(Tickets.FIELD_SUBJECT);
            if (ticketText.isEmpty() && (subjectValueReference == null || !subjectValueReference.hasReferenceValue() && StringFunctions.isEmpty((String)((String)subjectValueReference.getValue())))) {
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.parallel.noSubjectOrText", new Object[0]), process, pt);
            }
            for (ProcessCondition<?> pc : pt.getStartCondition()) {
                GUID activity;
                Activity target;
                if (pc.getType().equals(ConditionType.ALL_TICKETS_FINISHED.getTypeIdentifier())) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.condition.cannotUseConditionInParallelTicket", new Object[]{pc.getDisplayString(process), pt.getName()}), process, pt);
                }
                if (!pc.getType().equals(ConditionType.ACTIVITY_VISITED.getTypeIdentifier()) && !pc.getType().equals(ConditionType.ACTIVITY_FINISHED.getTypeIdentifier()) || (target = process.getActivity(activity = ((ProcessProgressingConditionValue)pc.getValue()).getItemId())).getType() != Activity.Type.FinishProcess) continue;
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.condition.cannotWaitForFinish", new Object[]{target.getName()}), process, pt);
            }
        }
        new DeadPathCheck(this).checkForDeadPathsAndThrow(dispatched, tickets);
    }

    private void checkActivities(TicketProcess process, List<Activity> activities, Activity start, boolean isMainTicket) {
        List<ActionVO> possibleActionsForTransition = TicketProcessManager.getPossibleActionsForTransition();
        if (isMainTicket) {
            if (process.getActivities().isEmpty()) {
                throw new ProcessValidationException("No activities in process " + process.getName(), process);
            }
            if (process.getStart().getType() == Activity.Type.FinishProcess) {
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.firstActCannotBeFinish", new Object[0]), process);
            }
        }
        HashSet<String> activitynames = new HashSet<String>();
        for (Activity a : activities) {
            if (this.allActivityIds.contains(a.getId())) {
                throw new ProcessValidationException("ID " + String.valueOf(a.getId()) + " in activity " + a.getName() + " is already used!", process, a);
            }
            this.allActivityIds.add(a.getId());
            if (a.getName().isBlank()) {
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.nameIsEmpty", new Object[0]), process, a);
            }
            if (activitynames.contains(a.getName())) {
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.uniquename", new Object[0]), process, a);
            }
            activitynames.add(a.getName());
            if (!this.isReferenced(a)) continue;
            if (!isMainTicket && a.getType() == Activity.Type.FinishProcess) {
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.onlyMainTicketCanFinishProcess", new Object[0]), process, a);
            }
            if (a.getNextProcessToStart() != null && a.getType() != Activity.Type.FinishProcess) {
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.onlyNextProcess", new Object[0]), process, a);
            }
            if (a.getType() == Activity.Type.FinishProcess) {
                if (!a.getFollowUpActivities().isEmpty()) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.nextprocessNoFollowing", new Object[0]), process, a);
                }
                if (Objects.equals(process.getId(), a.getNextProcessToStart())) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.nextprocessIsNotSelf", new Object[0]), process, a);
                }
                if (a.getNextProcessToStart() != null && ((TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class)).getProcess(a.getNextProcessToStart()) == null) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.nextprocessDoesNotExist", new Object[0]), process, a);
                }
            } else if (a.getType() == Activity.Type.Standard && a.getFollowUpActivities().isEmpty() && !ProcessAnalyser.anyActionClosesTicket(a) && !this.allTransitionToActivityAreClosingTicket(a, process)) {
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.mustHaveFollowing", new Object[0]), process, a);
            }
            if (a.getType() == Activity.Type.Standard) {
                ActionVO actionVO;
                for (Integer n : TicketProcessManager.ALWAYS_DISALLOWED_ACTIONS) {
                    if (!a.getPossibleActions().contains(n) || (actionVO = (ActionVO)ActionManager.getInstance().get(n.intValue())) == null) continue;
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.ForbiddenPossibleAction", new Object[]{actionVO.getDisplayValue()}), process, a);
                }
                for (Integer n : a.getPossibleActions()) {
                    actionVO = (ActionVO)ActionManager.getInstance().get(n.intValue());
                    if (actionVO == null) {
                        throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.transition.actionNotFound", new Object[]{n}), process, a);
                    }
                    if (!actionVO.isDeleted()) continue;
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.transition.actionIsDeleted", new Object[]{actionVO.getDisplayValue()}), process, a);
                }
                if (!isMainTicket) {
                    for (Integer n : TicketProcessManager.ALWAYS_DISALLOWED_ACTIONS_FOR_PARALLEL) {
                        if (!a.getPossibleActions().contains(n) || (actionVO = (ActionVO)ActionManager.getInstance().get(n.intValue())) == null) continue;
                        throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.ForbiddenPossibleAction", new Object[]{actionVO.getDisplayValue(), a.getName()}), process, a);
                    }
                }
            }
            List<String> requiredKeys = a.getRequiredFieldKeys();
            for (TicketField<?> f : a.getIncomingTicketData().getIncludedFields()) {
                if (requiredKeys.contains(f.getKey())) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.cannotRequireAndSetField", new Object[]{f.getLabel()}), process, a);
                }
                ProcessValueReference processValueReference = a.getIncomingTicketData().get(f);
                if (f == Tickets.FIELD_RESOURCE_GUID && processValueReference.hasConcreteValue() && processValueReference.getValue() == null && (isMainTicket || !start.getId().equals((Object)a.getId()))) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.cannotSetFieldToNull", new Object[]{f.getLabel()}), process, a);
                }
                this.validateFieldValue(f, processValueReference, a);
                if (!processValueReference.hasReferenceValue()) continue;
                GUID source = processValueReference.getParallelTicketId();
                if (source != null && !process.getParallelTickets().stream().anyMatch(pt -> pt.getId().equals((Object)source))) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.valueReference.missingTicket", new Object[]{f.getLabel()}), process, a);
                }
                if ((source == null || process.getParallelTicket(source).getStart() != start) && (source != null || !isMainTicket)) continue;
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.valueReference.cannotTakeFromSelf", new Object[]{f.getLabel()}), process, a);
            }
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<GUID> escalationTargetResources = new HashSet<GUID>();
            for (ActivityTransition tra : a.getFollowUpActivities()) {
                Iterator<ActionVO> targetResource;
                ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(tra.getActionid());
                if (actionVO == null) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.transition.actionNotFound", new Object[]{tra.getActionid(), a.getName()}), process, a);
                }
                String actionLabel = tra.getActionLabel();
                if (StringFunctions.isEmpty((String)actionLabel)) {
                    actionLabel = ActivityTransitionAction.generateLabelIfEmpty(actionVO, tra, start);
                }
                if (hashSet.contains(actionLabel)) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.transitionUniqueName", new Object[]{a.getName(), actionLabel}), process, a);
                }
                hashSet.add(actionLabel);
                if (!TicketProcessManager.getPossibleActionsForTransition().stream().anyMatch(action -> action.getId() == tra.getActionid())) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.transition.actionNotAllowed", new Object[]{actionVO.getDisplayValue(), tra.getNextActivity().getName()}), process, a);
                }
                if (!possibleActionsForTransition.contains(actionVO)) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.transitionForbiddenAction", new Object[]{actionVO.getDisplayValue()}), process, a);
                }
                if (tra.getActionid() == 8 && (targetResource = tra.getNextActivity().getIncomingTicketData().get(Tickets.FIELD_RESOURCE_GUID)) != null && ((ProcessValueReference)((Object)targetResource)).hasConcreteValue()) {
                    if (escalationTargetResources.contains(((ProcessValueReference)((Object)targetResource)).getValue())) {
                        throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.escalateResourceMustBeUnique", new Object[]{actionVO.getDisplayValue()}), process, a);
                    }
                    escalationTargetResources.add((GUID)((ProcessValueReference)((Object)targetResource)).getValue());
                }
                if (Status.isClosedOrDeletedStatus((int)actionVO.getStatusID()) && tra.getNextActivity().getNextProcessToStart() != null) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.FinishWithClosingTicketCannotStartNewProcess", new Object[]{tra.getNextActivity().getName()}), process, a);
                }
                if (tra.getNextActivity() != start && !tra.getNextActivity().getRequiredFieldKeys().isEmpty()) {
                    for (ActionVO currentAction : TicketProcessManager.getPossibleActionsForTransition()) {
                        if (!currentAction.isInternal() || actionVO.getId() != currentAction.getId()) continue;
                        throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.transition.actionCannotRequireFields", new Object[]{a.getName(), actionVO.getDisplayValue()}), process, tra.getNextActivity());
                    }
                }
                targetResource = tra.getNextActivity().getRequiredFieldKeys().iterator();
                while (targetResource.hasNext()) {
                    String requiredKey = (String)targetResource.next();
                    TicketField field = Tickets.getFieldByKey((String)requiredKey);
                    if (field == null) {
                        throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.unknownticketfield", new Object[]{requiredKey}), process, tra.getNextActivity());
                    }
                    int fieldChangeReaStepActionId = field.getFieldChangeReaStepActionId();
                    if (a.getPossibleActions().contains(fieldChangeReaStepActionId)) continue;
                    ActionVO action2 = (ActionVO)ActionManager.getInstance().get(fieldChangeReaStepActionId);
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.activityMustAllowFieldChange", new Object[]{field.getLabel(), tra.getNextActivity().getName(), action2.getDisplayValue()}), process, a);
                }
                if (!tra.isAutoTransition()) continue;
                if (!TicketProcessManager.getActionsWhichCanBeAllowedForAutoTransition().contains(tra.getActionid())) {
                    ActionVO action3 = (ActionVO)ActionManager.getInstance().get(tra.getActionid());
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.auto.actionCannotBeUsedForAutomatic", new Object[]{ProcessAnalyser.usedInAutoTransition(a, tra.getNextActivity()), action3.getDisplayValue()}), process, a);
                }
                if (!tra.getNextActivity().getRequiredFieldKeys().isEmpty()) {
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.auto.cannotRequireTicketField", new Object[]{ProcessAnalyser.usedInAutoTransition(a, tra.getNextActivity()), a.getName()}), process, a);
                }
                for (ProcessCondition<?> pc : tra.getConditionsForAutoTransition()) {
                    GUID activity;
                    Activity target;
                    if (pc.getType().equals(ConditionType.TICKET_FINISHED.getTypeIdentifier())) {
                        ProcessProgressingConditionValue value = ConditionType.TICKET_FINISHED.convert(pc.getConditionData());
                        TicketBranch parentBranch = this.findParentOfActivity(a.getId());
                        if (parentBranch.getPt() != null && parentBranch.getPt().getId().equals((Object)value.getItemId())) {
                            throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.condition.cannotWaitForOwnTicket", new Object[]{ProcessAnalyser.usedInAutoTransition(a, tra.getNextActivity())}), process, a);
                        }
                    }
                    if (pc.getType().equals(ConditionType.ALL_TICKETS_FINISHED.getTypeIdentifier()) && !isMainTicket) {
                        throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.condition.cannotUseConditionInParallelTicket", new Object[]{pc.getDisplayString(process), ProcessAnalyser.usedInAutoTransition(a, tra.getNextActivity())}), process, a);
                    }
                    if (pc.getType().equals(ConditionType.ALL_TICKETS_FINISHED.getTypeIdentifier()) && process.getParallelTickets().isEmpty()) {
                        throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.condition.cannotWaitForNotExistingParallelTickets", new Object[]{ProcessAnalyser.usedInAutoTransition(a, tra.getNextActivity())}), process, a);
                    }
                    if (!pc.getType().equals(ConditionType.ACTIVITY_VISITED.getTypeIdentifier()) && !pc.getType().equals(ConditionType.ACTIVITY_FINISHED.getTypeIdentifier()) || (target = process.getActivity(activity = ((ProcessProgressingConditionValue)pc.getValue()).getItemId())).getType() != Activity.Type.FinishProcess) continue;
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.condition.cannotWaitForFinish", new Object[]{target.getName()}), process, a);
                }
            }
        }
    }

    private <T> void validateFieldValue(TicketField<T> f, ProcessValueReference<?, ?> processValueReference, Activity a) {
        if (processValueReference.hasConcreteValue()) {
            Object value = processValueReference.getValue();
            if (value instanceof RelativeOrAbsoluteDate) {
                value = ((RelativeOrAbsoluteDate)value).toAbsoluteDate();
            }
            try {
                f.validateIsValidValue(value);
            }
            catch (FieldValidationException e) {
                throw new ProcessValidationException(e.getMessage() + " (" + a.getName() + ")", this.process, a);
            }
        }
    }

    private static String usedInAutoTransition(Activity parentActivity, Activity nextActivity) {
        return TicketProcessManager.MSG.getMsg("validation.condition.usedInTransition", new Object[]{parentActivity.getName(), nextActivity.getName()});
    }

    private boolean allTransitionToActivityAreClosingTicket(Activity a, TicketProcess process) {
        boolean foundOneOrMoreTransitionsClosingTicket = false;
        ArrayList<List<Activity>> allLists = new ArrayList<List<Activity>>();
        allLists.add(process.getActivities());
        process.getParallelTickets().forEach(pt -> allLists.add(pt.getActivities()));
        for (List list : allLists) {
            for (Activity act : list) {
                for (ActivityTransition tra : act.getFollowUpActivities()) {
                    if (tra.getNextActivity() != a) continue;
                    ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(tra.getActionid());
                    if (actionVO != null && Status.isOpenStatus((int)actionVO.getStatusID())) {
                        return false;
                    }
                    foundOneOrMoreTransitionsClosingTicket = true;
                }
            }
        }
        return foundOneOrMoreTransitionsClosingTicket;
    }

    public static boolean anyActionClosesTicket(Activity a) {
        for (Integer actionId : a.getPossibleActions()) {
            ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionId.intValue());
            if (actionVO == null || !Status.isClosedOrDeletedStatus((int)actionVO.getStatusID())) continue;
            return true;
        }
        return false;
    }

    boolean isReferenced(Activity a) {
        for (TicketBranch path : this.allPaths) {
            if (!path.getActivities().contains(a)) continue;
            return true;
        }
        return false;
    }

    public TicketBranch findParentOfActivity(GUID activity) {
        for (TicketBranch b : this.allPaths) {
            if (!b.getActivities().stream().anyMatch(a -> a.getId().equals((Object)activity))) continue;
            return b;
        }
        return null;
    }
}

