/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.search;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions.SetAttributesDirectlyExtension;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import java.util.Iterator;
import java.util.Map;

public class TicketDeletionListener
implements TicketEventListener {
    public void handleEvent(TicketEvent event) {
        event.getChangedTickets().forEach(ct -> {
            block7: {
                Map map;
                TicketVO oldTicket;
                block8: {
                    oldTicket = ct.getOldTicket();
                    TicketVO newTicket = ct.getNewTicket();
                    if (oldTicket == null || newTicket != null) break block7;
                    if (oldTicket.getAttribute(TicketProcessManager.ATTRIBUTE_PROCESS_START_DATE) == null) break block8;
                    Map children = (Map)oldTicket.getAttribute(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS);
                    for (Map.Entry en : children.entrySet()) {
                        int childId = (Integer)en.getValue();
                        TicketVO child = TicketManager.getReaderForSystem().getTicket(childId);
                        if (child == null) continue;
                        MutableTicketAttributes attrs = new MutableTicketAttributes();
                        attrs.put(TicketProcessManager.ATTRIBUTE_PROCESS, null);
                        attrs.put(TicketProcessManager.ATTRIBUTE_ACTIVITY, null);
                        attrs.put(TicketProcessManager.ATTRIBUTE_MAIN_TICKET, null);
                        attrs.put(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES, null);
                        try {
                            SetAttributesDirectlyExtension.silentlySetAttributesOfTicket(childId, attrs);
                        }
                        catch (IllegalArgumentException ee) {
                            TicketProcessPlugin.LOGGER.debug((Object)ee);
                        }
                    }
                    break block7;
                }
                if (oldTicket.getAttribute(TicketProcessManager.ATTRIBUTE_MAIN_TICKET) == null) break block7;
                int mainId = (Integer)oldTicket.getAttribute(TicketProcessManager.ATTRIBUTE_MAIN_TICKET);
                TicketVO main = TicketManager.getReaderForSystem().getTicket(mainId);
                if (main != null && (map = (Map)main.getAttribute(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS)) != null) {
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry en = iterator.next();
                        if (((Integer)en.getValue()).intValue() != oldTicket.getID()) continue;
                        iterator.remove();
                    }
                    MutableTicketAttributes attrs = new MutableTicketAttributes();
                    attrs.put(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS, (Object)map);
                    try {
                        SetAttributesDirectlyExtension.silentlySetAttributesOfTicket(mainId, attrs);
                    }
                    catch (IllegalArgumentException ee) {
                        TicketProcessPlugin.LOGGER.debug((Object)ee);
                    }
                }
            }
        });
    }
}

