/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.fields;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettings;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessProgress;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.AbstractTicketDefinitionForProcessAttributes;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import java.text.Collator;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketFieldDefinitionProcess
extends AbstractTicketDefinitionForProcessAttributes {
    public TicketFieldDefinitionProcess() {
        super(TicketProcessManager.ATTRIBUTE_PROCESS, true, false, 1000);
    }

    public String getDisplayValue(TicketVO ticket) {
        TicketProcess attribute;
        try {
            attribute = TicketProcessManager.getProcessOfTicket(ticket);
        }
        catch (AccessDeniedException ex) {
            return null;
        }
        if (attribute == null) {
            return null;
        }
        if (ticket.isSlaveInBundle()) {
            try {
                ticket = TicketManager.getReader().getTicket(ticket.getBundleID());
            }
            catch (AccessDeniedException ex) {
                // empty catch block
            }
        }
        Boolean isOriginal = (Boolean)ticket.getAttribute(TicketProcessManager.ATTRIBUTE_ORIGINAL_PROCESS);
        TicketProcessProgress progress = ((TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class)).getProgressFor(ticket.getID());
        return attribute.getName() + (String)(isOriginal != false ? "" : " (" + TicketProcessManager.MSG.getMsg("field.ticketprocess.modifiedsuffix", new Object[0]) + ")") + (String)(progress == null ? "" : " - " + progress.getProgressPct() + "%");
    }

    public String getDescription(TicketVO ticket) {
        TicketProcess processOfTicket = TicketProcessManager.getProcessOfTicket(ticket);
        if (processOfTicket == null) {
            return this.getDescription();
        }
        return processOfTicket.getDescription();
    }

    @Nonnull
    public Comparator<TicketVO> getComparator() {
        Collator comp = Collator.getInstance(ClientLocale.getThreadLocale());
        Comparator<Object> nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> {
            int mainB;
            TicketProcess processB;
            TicketProcess processA = TicketProcessManager.getProcessOfTicket(a);
            int result = nullsFirst.compare(processA == null ? "" : processA.getName(), (processB = TicketProcessManager.getProcessOfTicket(b)) == null ? "" : processB.getName());
            if (result != 0) {
                return result;
            }
            int mainA = this.getProcessMainId((TicketVO)a);
            result = Integer.compare(mainA, mainB = this.getProcessMainId((TicketVO)b));
            if (result != 0) {
                return result;
            }
            return Integer.compare(a.getID(), b.getID());
        };
    }

    public SortGroupInformation getSortGroupInformation() {
        return new SortGroupInformation(){

            public boolean supportsSortGroups() {
                return true;
            }

            public String getSortGroupKey(TicketVO ticket) {
                if (ticket == null) {
                    return "";
                }
                TicketProcess process = TicketProcessManager.getProcessOfTicket(ticket);
                if (process == null) {
                    return "";
                }
                String displayValue = process.getName().trim();
                int main = TicketFieldDefinitionProcess.this.getProcessMainId(ticket);
                if (main == ticket.getID() && ((Map)ticket.getAttribute(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS)).isEmpty()) {
                    return displayValue;
                }
                Object subject = "";
                if (main == ticket.getID()) {
                    subject = " " + ticket.getSubject();
                } else {
                    try {
                        TicketVO mainTicket = TicketManager.getReader().getTicket(main);
                        if (mainTicket != null) {
                            subject = " " + mainTicket.getSubject();
                        }
                    }
                    catch (AccessDeniedException accessDeniedException) {
                        // empty catch block
                    }
                }
                return displayValue + " - #" + main + (String)subject;
            }

            public SortGroup getSortGroupForKey(String sortGroupKey) {
                if (StringFunctions.isEmpty((String)sortGroupKey)) {
                    sortGroupKey = TicketProcessManager.MSG.getMsg("field.grouping.nonSet", new Object[0]);
                }
                return new SortGroup(sortGroupKey);
            }
        };
    }

    private int getProcessMainId(TicketVO ticket) {
        Integer main = (Integer)ticket.getAttribute(TicketProcessManager.ATTRIBUTE_MAIN_TICKET);
        if (main == null) {
            return ticket.getID();
        }
        return main;
    }

    @Nullable
    public FieldSettingsType getDisplayType() {
        return TicketFieldSettings.TYPE_OTHER;
    }
}

