/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ConditionType;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.plugin.ServerPluginManager;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@JsonData
@Immutable
public class ProcessCondition<T> {
    private String conditionData;
    private String type;
    private transient ConditionType<T> typeVar;
    private transient T value;

    private ProcessCondition() {
    }

    public ProcessCondition(T conditionValue, ConditionType<T> type) {
        this.conditionData = type.convert(conditionValue);
        this.value = conditionValue;
        this.type = type.getTypeIdentifier();
        this.typeVar = type;
    }

    public boolean resolve(ProcessTickets tickets) {
        this.restoreTransientRef();
        return this.typeVar.resolve(this.value, tickets);
    }

    private void restoreTransientRef() {
        if (this.typeVar == null) {
            Optional<ConditionType> match = ServerPluginManager.getInstance().get(ConditionType.class).stream().filter(ct -> ct.getTypeIdentifier().equals(this.type)).findFirst();
            if (match.isEmpty()) {
                throw new IllegalStateException("Condition type not found: " + this.type);
            }
            ConditionType conditionType = match.get();
            this.value = conditionType.convert(this.conditionData);
            this.typeVar = conditionType;
        }
    }

    public String getConditionData() {
        return this.conditionData;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayString(TicketProcess process) {
        this.restoreTransientRef();
        return this.typeVar.getDisplayString(this.value, process);
    }

    public String getDisplayString(TicketProcess process, ProcessTickets currentState) {
        this.restoreTransientRef();
        return this.typeVar.getDisplayString(this.value, process, currentState);
    }

    public T getValue() {
        this.restoreTransientRef();
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conditionData == null ? 0 : this.conditionData.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessCondition other = (ProcessCondition)obj;
        if (this.conditionData == null ? other.conditionData != null : !this.conditionData.equals(other.conditionData)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

