/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model;

import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.id.GUID;
import com.inet.remote.gui.modules.importexport.ExportableWidget;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TicketProcessFolder
implements ExportableWidget {
    private GUID id;
    private String name;
    private TicketProcessFolder parent;
    private List<TicketProcessFolder> subFolders;
    private List<TicketProcess> processes;

    public TicketProcessFolder(GUID id, String name, List<TicketProcessFolder> subFolders, List<TicketProcess> processes) {
        this.id = id;
        this.name = name;
        this.subFolders = Collections.unmodifiableList(subFolders);
        this.processes = Collections.unmodifiableList(processes);
        for (TicketProcessFolder sub : subFolders) {
            sub.parent = this;
        }
    }

    public GUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TicketProcessFolder getParent() {
        return this.parent;
    }

    public List<TicketProcessFolder> getSubFolders() {
        return this.subFolders;
    }

    public List<TicketProcess> getProcesses() {
        return this.processes;
    }

    public boolean isEmpty() {
        for (TicketProcessFolder subfolder : this.subFolders) {
            if (subfolder.isEmpty()) continue;
            return false;
        }
        return this.processes.size() == 0;
    }
}

