/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessSettings;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.ProcessAnalyser;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.modules.importexport.ExportableWidget;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonData
@Immutable
public class TicketProcess
implements ExportableWidget {
    private GUID id;
    private String name;
    private String description;
    private AdditionalResourceAccess autoResourceAccess = AdditionalResourceAccess.NONE;
    private boolean canBeChangedWhenActive = false;
    private List<Activity> activities;
    private transient Activity start;
    private GUID startActivityId;
    private List<ParallelTicket> parallelTickets;
    private transient boolean restoring = false;
    private transient boolean noErrors = false;
    private transient IllegalArgumentException validationException;

    private TicketProcess() {
    }

    public TicketProcess(GUID id, String name, String description, List<Activity> activities, GUID startActivityId, List<ParallelTicket> parallelTickets, AdditionalResourceAccess autoResourceAccess, boolean canBeChangedWhenActive) {
        Objects.requireNonNull(id, "id cannot be null");
        if (StringFunctions.isEmpty((String)name)) {
            throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.process.nameIsEmpty", new Object[0]));
        }
        if (startActivityId == null) {
            throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.process.noStartActivity", new Object[0]));
        }
        Objects.requireNonNull(activities, "activities cannot be null or empty");
        Objects.requireNonNull(parallelTickets, "Parallel tickets cannot be null or empty");
        Objects.requireNonNull(autoResourceAccess);
        this.id = id;
        this.name = name;
        this.description = description;
        this.activities = Collections.unmodifiableList(activities);
        this.startActivityId = startActivityId;
        this.parallelTickets = Collections.unmodifiableList(parallelTickets);
        this.autoResourceAccess = autoResourceAccess;
        this.canBeChangedWhenActive = canBeChangedWhenActive;
        this.restoreReferencesLazy();
    }

    public String getName() {
        this.restoreReferencesLazy();
        return this.name;
    }

    @Nullable
    public String getDescription() {
        this.restoreReferencesLazy();
        return this.description;
    }

    public List<Activity> getActivities() {
        this.restoreReferencesLazy();
        return Collections.unmodifiableList(this.activities);
    }

    public Activity getActivity(GUID id) {
        this.restoreReferencesLazy();
        for (Activity a : this.activities) {
            if (!a.getId().equals((Object)id)) continue;
            return a;
        }
        for (ParallelTicket pt : this.parallelTickets) {
            for (Activity a : pt.getActivities()) {
                if (!a.getId().equals((Object)id)) continue;
                return a;
            }
        }
        return null;
    }

    public Activity getStart() {
        this.restoreReferencesLazy();
        return this.start;
    }

    public List<ParallelTicket> getParallelTickets() {
        this.restoreReferencesLazy();
        return Collections.unmodifiableList(this.parallelTickets);
    }

    public ParallelTicket getParallelTicket(GUID id) {
        this.restoreReferencesLazy();
        return this.parallelTickets.stream().filter(pt -> pt.getId().equals((Object)id)).findFirst().orElseThrow(() -> new IllegalStateException("no parallel ticket with id = " + String.valueOf(id)));
    }

    public void validate() {
        this.restoreReferencesLazy();
        if (!this.activities.stream().anyMatch(a -> a.getId().equals((Object)this.startActivityId))) {
            throw new IllegalStateException("activities must contain start activity");
        }
        if (this.noErrors) {
            return;
        }
        if (this.validationException != null) {
            throw new IllegalArgumentException(this.validationException.getMessage(), this.validationException);
        }
        try {
            ProcessAnalyser.validate(this);
            this.noErrors = true;
        }
        catch (IllegalArgumentException ex) {
            this.validationException = ex;
            throw ex;
        }
    }

    public GUID getId() {
        this.restoreReferencesLazy();
        return this.id;
    }

    public AdditionalResourceAccess getAutoResourceAccess() {
        return this.autoResourceAccess;
    }

    public boolean canBeChangedWhenActive() {
        return this.canBeChangedWhenActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreReferencesLazy() {
        if (this.start == null) {
            TicketProcess ticketProcess = this;
            synchronized (ticketProcess) {
                if (this.start == null && !this.restoring) {
                    this.restoring = true;
                    try {
                        Activity startX = null;
                        for (Activity a : this.activities) {
                            if (a.getId().equals((Object)this.startActivityId)) {
                                startX = a;
                            }
                            a.restoreReferences(this.activities, this);
                        }
                        if (startX == null) {
                            throw new IllegalStateException("activities must contain start activity");
                        }
                        if (this.parallelTickets != null) {
                            for (ParallelTicket p : this.parallelTickets) {
                                p.restoreReferences(this);
                            }
                        } else {
                            this.parallelTickets = Collections.emptyList();
                        }
                        this.start = startX;
                    }
                    finally {
                        this.restoring = false;
                    }
                }
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activities == null ? 0 : this.activities.hashCode());
        result = 31 * result + (this.autoResourceAccess == null ? 0 : this.autoResourceAccess.hashCode());
        result = 31 * result + (this.canBeChangedWhenActive ? 1231 : 1237);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parallelTickets == null ? 0 : this.parallelTickets.hashCode());
        result = 31 * result + (this.startActivityId == null ? 0 : this.startActivityId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketProcess other = (TicketProcess)obj;
        if (this.activities == null ? other.activities != null : !this.activities.equals(other.activities)) {
            return false;
        }
        if (this.autoResourceAccess != other.autoResourceAccess) {
            return false;
        }
        if (this.canBeChangedWhenActive != other.canBeChangedWhenActive) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals((Object)other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parallelTickets == null ? other.parallelTickets != null : !this.parallelTickets.equals(other.parallelTickets)) {
            return false;
        }
        return !(this.startActivityId == null ? other.startActivityId != null : !this.startActivityId.equals((Object)other.startActivityId));
    }

    public String toString() {
        return "TicketProcess [id=" + String.valueOf(this.id) + ", name=" + this.name + ", description=" + this.description + ", activities=" + String.valueOf(this.activities) + ", startActivityId=" + String.valueOf(this.startActivityId) + "]";
    }

    public ActiveProcess toActiveProcessWithoutModifications() {
        return new ActiveProcess(this, new TicketProcessSettings(Collections.emptyMap()));
    }

    public static enum AdditionalResourceAccess {
        NONE,
        READ,
        WRITE;

    }
}

