/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.ticketlist;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.ticketlist.api.fieldconditions.FieldCondition;
import com.inet.helpdesk.plugins.ticketlist.api.fieldconditions.FieldConditionAction;
import com.inet.helpdesk.plugins.ticketlist.api.fieldconditions.FieldConditionProvider;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProcessMandatoryFieldsFieldConditionProvider
implements FieldConditionProvider {
    @Nullable
    public List<FieldCondition> getConditionsForAction(@Nonnull ActionVO action, @Nullable List<Integer> ticketIds) {
        if (action.getId() == -19) {
            ArrayList tickets = null;
            ArrayList<FieldCondition> conditions = new ArrayList<FieldCondition>();
            TicketProcessManager manager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
            List<TicketProcess> processes = manager.getProcesses();
            for (TicketProcess process : processes) {
                Activity start = process.getStart();
                List<String> requiredFieldKeys = start.getRequiredFieldKeys();
                if (requiredFieldKeys == null || requiredFieldKeys.isEmpty()) continue;
                ArrayList<FieldConditionAction.VisibleFieldConditionAction> actions = new ArrayList<FieldConditionAction.VisibleFieldConditionAction>();
                for (String requiredFieldKey : requiredFieldKeys) {
                    TicketField fieldByKey;
                    if (tickets == null) {
                        tickets = new ArrayList();
                        if (ticketIds != null) {
                            tickets.addAll(TicketManager.getReader().getTickets(ticketIds));
                        }
                    }
                    if (!tickets.isEmpty() && (fieldByKey = Tickets.getFieldByKey((String)requiredFieldKey)) != null) {
                        boolean setForAll = true;
                        for (TicketVO ticket : tickets) {
                            Object value = ticket.getValue(fieldByKey);
                            if (this.isValueSet(fieldByKey, value)) continue;
                            setForAll = false;
                            break;
                        }
                        if (setForAll) continue;
                    }
                    actions.add(new FieldConditionAction.VisibleFieldConditionAction(requiredFieldKey));
                }
                conditions.add(new FieldCondition("ticketprocess", FieldCondition.OP.contains, process.getId().toString(), actions));
            }
            return conditions;
        }
        return null;
    }

    private boolean isValueSet(TicketField<?> field, Object value) {
        return value != null && (!(value instanceof String) || !((String)value).isBlank()) && !this.classificationSonderhack(field, value);
    }

    private boolean classificationSonderhack(TicketField<?> field, Object value) {
        return field == Tickets.FIELD_CLASSIFICATION_ID && value instanceof Integer && (Integer)value == 0;
    }
}

